 <div class="table-responsive">
     <div class="d-flex justify-content-between">
         <h5 class="mb-0">Prices and Batch</h5>
         @if(auth()->user()->can('product-prices-create'))
         <button type="button" class="btn btn-primary" id="createPrice" data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New</button>
         @endif
     </div>
     <hr class="mb-2">
     <table id="example" class="table table-bordered align-middle" style="width:100%">
         <thead class="table-light">
             <tr>
                 <th class="thbutton">Sl No</th>
                 <th>Batch</th>
                 <th>Sale Price</th>
                 <th>W. Price</th>
                 <th>Pur.Price</th>
                 <th>MRP</th>
                 <th>Min. SP</th>
                 <th>Pack Stock</th>
                 <th>Loose Stock</th>
                 <th>Exp. Date</th>
                 <th>Mfg. Cost</th>
                 @if(auth()->user()->can('product-prices-edit'))
                 <th class="thbutton">Status</th>
                 <th class="thbutton">Edit</th>
                 @endif
                 {{-- @if(auth()->user()->can('product-prices-delete'))
                <th class="thbutton">Delete</th>
                @endif --}}
             </tr>
         </thead>
         <tbody>
             @php $i=1;@endphp
             @if(count($prices)>0)
             @foreach($prices as $key=> $list)
             <tr>
                 <td class="text-center">{{ 1 + $key}}</td>
                 <td>{{$list->batch?ucfirst($list->batch):'N/A'}}</td>
                 <td>{{$list->sale_price}}</td>
                 <td>{{$list->wholesale_price}}</td>
                 <td>{{$list->purchase_price}}</td>
                 <td>{{$list->mrp}}</td>
                 <td>{{$list->min_sale_price}}</td>
                 <td>{{$list->opening_stock_pack}}</td>
                 <td>{{$list->opening_stock_loose}}</td>
                 <td>{{ formatedDate($list->exp_date) }}</td>
                 <td>{{$list->mfg_cost}}</td>
                 @if(auth()->user()->can('product-prices-edit'))
                 <td>
                     <div class="col-md-3 form-check form-check-inline-raw">
                         <input class="form-check-input-raw btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox-raw" data-url="{{route('product-prices.changeStatus')}}" data-id="{{$list->id}}" data-status="{{$list->status=='0' ? '1' : '0'}}" {{ $list->status=='1' ? 'checked' : ''}}>
                     </div>
                 </td>
                 <td>
                     <button data-id="{{ $list->id }}" class="btn btn-warning prices_edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                         <i class="bi bi-pencil-square text-white"></i>
                     </button>
                 </td>
                 @endif
                 {{-- @if(auth()->user()->can('product-prices-delete'))
                        <td>
                            <a data-url="{{route('products.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                 <i class="bi bi-trash text-white"></i>
                 </a>
                 </td>
                 @endif --}}
             </tr>
             @php $i++; @endphp
             @endforeach
             @else
             <tr>
                 <td colspan="12">No Data Found</td>
             </tr>
             @endif
         </tbody>
     </table>
 </div>
 </div>