<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Product Name</th>
                <th>HSN Number</th>
                <th>Batch</th>
                <th>Exp. Date</th>
                <th>OP. Pack</th>
                <th>OP. Loose</th>
                <th>MRP</th>
                <th class="text-end">Purchase Price</th>
                <th class="text-end">Sale Price</th>
                <th class="thbutton">Edit</th>
                <th class="thbutton">Delete</th>
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td>{{$list->product_name}}</td>
                        <td>{{$list->product_hsn}}</td>
                        <td>{{$list->batch}}</td>
                        <td>{{ formatedDate($list->exp_date) }}</td>
                        <td style="text-align: right">{{$list->opening_stock_pack}}</td>
                        <td style="text-align: right">{{$list->opening_stock_loose}}</td>
                        <td style="text-align: right">{{$list->product_mrp}}</td>
                        <td style="text-align: right">{{$list->purchase_price}}</td>
                        <td style="text-align: right">{{$list->sale_price}}</td>

                        {{-- @if(auth()->user()->can('tax-masters-edit')) --}}
                        <td class="text-center">
                            <button data-id="{{ $list->id }}" class="btn btn-warning edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </button>
                        </td>
                        {{-- @endif --}}
                        {{-- @if(auth()->user()->can('tax-masters-delete')) --}}
                        <td class="text-center">
                            <a data-url="{{route('products-import.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        {{-- @endif --}}
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="9">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="row align-items-center mt-3">
    <div class="col-md-6">
        {!! $data->onEachSide(0)->render('products.import-pagination') !!}
    </div>
    <div class="col-md-6" style="display: flex; justify-content: end;">
        <div class="btn-group mb-0" style=" margin-left: 194px;">
            <a href="{{route('products-import.modal')}}" class="btn btn-outline-primary"><i class="bx bx-upload"></i>
                Import Products From Excel</a>
        </div>

        @if(count($data)>0)
            <div class="btn-group mx-2">
                <button type="button" class="btn btn-danger" id="clear_temp"><i class="bi bi-trash"></i> Clear Temp Data</button>
            </div>
        @endif

        {{-- <div class="btn-group mb-0">
            <a href="{!! route('accounts-import.export-sample') !!}" class="btn btn-outline-primary mx-2" target="_blank"><i
                    class="bi bi-cloud-download"></i> Download Sample</a>
        </div> --}}
    </div>
</nav>
</div>

