<div class="table-responsive">
    <div class="d-flex justify-content-between">
        <h5 class="mb-0">Project Budget</h5>
        @if (auth()->user()->can('project-budget-create'))
            <button type="button" class="btn btn-primary" id="createProjectBudget" data-bs-toggle="modal"
                data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New</button>
        @endif
    </div>
    <hr class="mb-2">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Budget Type</th>
                <th  class="thbutton" >Type</th>
                <th style="width: 10%; text-align:right">Amount</th>
                {{-- <th class="thbutton">Status</th> --}}
                @if(in_array('project-budget-edit', $authRolePermissions))
                    <th class="thbutton">Edit</th>
                @endif
                @if(in_array('project-budget-delete', $authRolePermissions))
                    <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        {{-- <tbody>
            @php $i=1;@endphp
            @if (count($projectBudget) > 0)
                @foreach ($projectBudget as $key => $list)
                <tr>
                    <td class="text-center">{{ $key + 1}}</td>
                    <td>{{ucfirst($list->getBudget->name ?? '')}}</td>
                    <td>{{convertDecimelPoint($list->amount)}}</td>


                    <td>
                        <div class="form-check form-check-inline{{$i}}">
                            <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('project-budget.changestatus')}}" data-id="{{$list->id}}" data-status="{{$list->status=='0' ? '1' : '0'}}" {{ $list->status=='1' ? 'checked' : ''}}>
                        </div>
                    </td>
                    @if (auth()->user()->can('project-budget-edit'))
                    <td style="font-size: 5px;">
                        <button type="button" class="btn btn-outline-secondary" data-id="{!! $list->id !!}" id="project_budget_edit"  data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bi bi-pencil-square"></i></i></button>
                    </td>
                    @endif
                    @if (auth()->user()->can('project-budget-delete'))
                    <td class="text-center">
                        <a data-url="{{route('project-budget.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteAccountData budget_project" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                            <i class="bi bi-trash text-white"></i>
                        </a>
                    </td>
                    @endif
                </tr>
                    @php $i++; @endphp
                @endforeach
            @else
            <tr>
                <td colspan="12">No Data Found</td>
            </tr>
            @endif
        </tbody> --}}
        <tbody>
            @php
                $i = 1;
                $totalAmount = 0;
            @endphp
            @if (count($projectBudget) > 0)
                @foreach ($projectBudget as $key => $list)
                    <tr>
                        <td class="text-center">{{ $key + 1 }}</td>
                        <td>{{ ucfirst($list->getBudget->name ?? '') }}</td>
                        <td style="color: {{ $list->getBudget->budget_calculation == 'income' ? 'green' : 'red' }}; text-align:left;">
                            {{ ucfirst($list->getBudget->budget_calculation ?? '') }}
                        </td  >
                        {{-- <td>{{ convertDecimelPoint($list->amount) }}</td> --}}
                        <td style="color: {{ $list->getBudget->budget_calculation == 'income' ? 'green' : 'red' }}; text-align:right;">
                            @if ($list->getBudget->budget_calculation == 'expense')
                                -{{ convertDecimelPoint($list->amount) }}
                            @else
                                {{ convertDecimelPoint($list->amount) }}
                            @endif
                        </td>                        {{-- <td>
                            <div class="form-check form-check-inline{{ $i }}">
                                <input class="form-check-input{{ $i }} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{ $i }}" data-url="{{ route('project-budget.changestatus') }}" data-id="{{ $list->id }}" data-status="{{ $list->status == '0' ? '1' : '0' }}" {{ $list->status == '1' ? 'checked' : '' }}>
                            </div>
                        </td> --}}
                        @if(in_array('project-budget-edit', $authRolePermissions))
                            <td style="font-size: 5px;">
                                <button type="button" class="btn btn-outline-secondary"
                                    data-id="{!! $list->id !!}" id="project_budget_edit" data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bi bi-pencil-square"></i></i></button>
                            </td>
                        @endif
                        @if(in_array('project-budget-delete', $authRolePermissions))
                            <td class="text-center">
                                <a data-url="{{ route('project-budget.destroy') }}" data-id="{{ $list->id }}" class="btn btn-danger deleteAccountData budget_project" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                    <i class="bi bi-trash text-white"></i>
                                </a>
                            </td>
                        @endif
                    </tr>
                    @php
                        $i++;
                        // Update total amount based on income or expense
                        if ($list->getBudget->budget_calculation == 'income') {
                            $totalAmount += $list->amount;

                        } elseif ($list->getBudget->budget_calculation == 'expense') {
                            $totalAmount -= $list->amount;
                        }
                    @endphp
                @endforeach
                <!-- Display total sum row at the bottom -->
                <tr>
                    <td></td>
                    <td><strong>Total</strong></td>
                    <td></td>
                    <td style="text-align:right; background-color: {{ $totalAmount < 0 ? 'red' : 'rgb(230, 230, 123)' }}; color: {{ $totalAmount < 0 ? 'white' : 'black' }}"><strong>{{ convertDecimelPoint($totalAmount) }}</strong></td>

                    <td colspan="3"></td>
                </tr>
            @else
                <tr>
                    <td colspan="12">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
</div>
