<div class="table-responsive">
    <div class="d-flex justify-content-between">
        <h5 class="mb-0">Project Requirements</h5>
        @if(auth()->user()->can('project-requirement-create'))
        <button type="button" class="btn btn-primary" id="createProjectRequirment"  data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New</button>
        @endif
    </div>
    <hr class="mb-2">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Task Type  </th>
                <th>Features</th>
                <th width="10%">Status</th>
                @if(in_array('project-requirement-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('project-requirement-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($ProjectRequirment)>0)
                @foreach($ProjectRequirment as $key=> $list)
                <tr>
                    <td class="text-center">{{ $key + 1}}</td>
                    <td>{{$list->getProjectType->title ?? ''}}</td>
                    <td>{{$list->features}}</td>
                    <td>
                        <div class="form-check form-check-inline{{$i}}">
                            <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('project-requirements.changestatus')}}" data-id="{{$list->id}}" data-status="{{$list->status=='0' ? '1' : '0'}}" {{ $list->status=='1' ? 'checked' : ''}}>
                        </div>
                    </td>
                    @if(in_array('project-requirement-edit', $authRolePermissions))
                    <td style="font-size: 5px;">
                        <button type="button" class="btn btn-outline-secondary" data-id="{!! $list->id !!}" id="project_requirements_edit"  data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bi bi-pencil-square"></i></i></button>
                    </td>
                    @endif
                    @if(in_array('project-requirement-delete', $authRolePermissions))
                    <td class="text-center">
                        <a data-url="{{route('project-requirements.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteAccountData project_requirments" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                            <i class="bi bi-trash text-white"></i>
                        </a>
                    </td>
                    @endif
                </tr>
                    @php $i++; @endphp
                @endforeach
            @else
            <tr>
                <td colspan="12">No Data Found</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>
</div>

