<form class="row g-3 auto-width project_attachments" action="{{ route('project-teams.update', $data->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('PUT')
    <!-- User -->

    <div class="col-md-12">
        <div>
            <label for="team_user_id" class="form-label">Team User <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="team_user_id">
                <option value="">--Select Team User --</option>
                @foreach($user_id as $list)
                <option value="{{ $list->id }}" {{ $list->id == $data->team_user_id ? 'selected':'' }}>{{ $list->name }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_team_user_id" style="display: none;">This field is required.</span>
    </div>
    <!-- role in project -->
    <div class="col-md-12">
        <label class="form-label">Role In Project <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="role_in_project" name="role_in_project" aria-describedby="inputGroupPrepend" required placeholder="Enter Rple In Project" value="{{$data->role_in_project}}">
        @if ($errors->has('role_in_project'))
        <span class="text-danger">{{ $errors->first('role_in_project') }}</span>
        @endif
        <span class="text-danger error_role_in_project" style="display: none;">This field is required.</span>
    </div>
     <!-- Assign date -->
     <div class="col-md-6">
        <div>
            <label for="assign_date" class="form-label"> Assign Date </label>
        </div>
        <div class="input-group">
            <input type="" name="assign_date" class="form-control" id="assign_date" autocomplete="off" placeholder="Select Assign Date"  value="{{$data->assign_date}}" readonly style="cursor: pointer;">
        </div>
        @if ($errors->has('assign_date'))
            <span class="text-danger">{{ $errors->first('assign_date') }}</span>
        @endif
        <span class="text-danger error_recieve_date" style="display: none;">This field is required.</span>
     </div>
     <!-- Release date -->
     <div class="col-md-6">
        <div>
            <label for="release_date" class="form-label"> Release Date </label>
        </div>
        <div class="input-group">
            <input type="" name="release_date" class="form-control" id="release_date" autocomplete="off"  placeholder="Select Relase Date"  value="{{$data->release_date}}" readonly style="cursor: pointer;">
        </div>
        @if ($errors->has('release_date'))
            <span class="text-danger">{{ $errors->first('release_date') }}</span>
        @endif
        <span class="text-danger error_recieve_date" style="display: none;">This field is required.</span>
     </div>
    <!-- hidden project id -->
    <input type="hidden" name="project_id" value="{{$data->project_id}}">
</form>
