@extends('layouts.app')
@section('title', 'Project')
@section('pages')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Project List</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Add New Project</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('projects.index')}}" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->
<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width" action="{{ route('projects.update', $project->id) }}" method="POST" enctype='multipart/form-data' id="projects">
                        @csrf
                        @method('patch')
                        <!-- validated columns -->
                        <!-- <form class="row g-3 was-validated"> -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Project Details</h5>
                                    <hr class="mb-0">
                                      <!-- recieve date -->
                                      <div class="col-md-6">
                                        <div>
                                            <label for="receive_date" class="form-label">Project Recieve Date </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="receive_date" class="form-control" id="receive_date" autocomplete="off" value="{!! $project->receive_date !!}" readonly>
                                        </div>
                                        @if ($errors->has('receive_date'))
                                            <span class="text-danger">{{ $errors->first('receive_date') }}</span>
                                        @endif
                                        <span class="text-danger error_recieve_date" style="display: none;">This field is required.</span>
                                    </div>
                                     <!-- project_type_id -->
                                     <div class="col-md-6">
                                        <div>
                                            <label for="project_type_id" class="form-label">Project Type <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select class="form-control" name="project_type_id">
                                                <option value=""> -- Select Project Type  -- </option>
                                                @foreach ($projectType as $list)
                                                    <option value="{{ $list->id }}" {{ matchSelected($list->id, $project->project_type_id) }}>{{ $list->title }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <span class="text-danger error_project_type_id" style="display: none;">This field is required.</span>
                                    </div>
                                    <!-- Title -->
                                    <div class="col-md-12">
                                        <label for="title" class="form-label">Project Title <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="title" name="title" aria-describedby="inputGroupPrepend" required placeholder="Title" value="{!! $project->title !!}">
                                        <span class="text-danger error_title" style="display:none;">This field is required.</span>
                                    </div>
                                    <!-- about -->
                                    <div class="col-md-12">
                                        <label for="about" class="form-label">About</label>
                                        <textarea class="form-control" max=100 id="about" name="about" placeholder="About" value={{$project->about}}></textarea>
                                    </div>

                                </div>
                                <div class="card-body g-3 row additional_fields">
                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                            <button class="btn btn-primary save_project">Save Record</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Additional Information</h5>
                                    <hr class="mb-0">
                                     <!-- Organization Department -->
                                     <div class="col-md-12" id="test_items">
                                        <label for="department_id" class="form-label"> Department <span class="text-danger"><b>*</b></span></label>
                                    </div>
                                    <div class="input-group">
                                        <select class="multi-select-tests" multiple name="department_id[]">
                                            @foreach ($department as $key => $value)
                                                <option value="{{ $value->id }}" {!! in_array($value->id, $department_ids) ? 'selected' : '' !!}>{{ $value->name }}</option>
                                            @endforeach
                                        </select>
                                        {{-- Add a button or other elements if needed --}}
                                    </div>
                                    <span class="text-danger error_department_id" style="display: none;">This field is required.</span>

                                     <!-- product_category_id -->
                                     <div class="col-md-6">
                                        <div>
                                            <label for="product_category_id" class="form-label">Product Category </label>
                                        </div>
                                        <div class="input-group">
                                            <select class="form-control" name="product_category_id">
                                                <option value=""> -- Select Product Category  -- </option>
                                                @foreach ($productCategory as $list)
                                                <option value="{{ $list->id }}" {{ matchSelected($list->id, $project->product_category_id) }}>{{ $list->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <span class="text-danger error_product_category_id" style="display: none;">This field is required.</span>
                                    </div>

                                    <!-- start date -->
                                    <div class="col-md-6">
                                        <div>
                                            <label for="start_date" class="form-label"> Start Date </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="" name="start_date" class="form-control" id="start_date" autocomplete="off" value="{!! $project->start_date !!}" readonly>
                                        </div>
                                        @if ($errors->has('start_date'))
                                            <span class="text-danger">{{ $errors->first('start_date') }}</span>
                                        @endif
                                    </div>
                                    <!-- dead_line date -->
                                    <div class="col-md-6">
                                        <div>
                                            <label for="dead_line_date" class="form-label"> Dead Line Date </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="" name="dead_line_date" class="form-control" id="dead_line_date" autocomplete="off" value="{!! $project->dead_line_date !!}" readonly>
                                        </div>
                                        @if ($errors->has('dead_line_date'))
                                            <span class="text-danger">{{ $errors->first('dead_line_date') }}</span>
                                        @endif
                                    </div>
                                    {{-- <div class="col-md-6">
                                        <label for="claim_status" class="form-label">Claim Status</label>
                                        <input type="text" class="form-control" id="claim_status" name="claim_status" aria-describedby="inputGroupPrepend" required placeholder="Claim Status">
                                        <span class="text-danger error_claim_status" style="display:none;">This field is required.</span>
                                    </div> --}}
                                    <!-- Priority -->
                                    <div class="col-md-12"  style="display: none;">
                                        <label for="priority" class="form-label">Priority <span class="text-danger"><b>*</b></span></label>
                                        <input type="number" class="form-control" name="priority" aria-describedby="inputGroupPrepend" required value="{!! $project->priority !!}">
                                        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end row-->
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
    <script>
           $('.multi-select-tests').select2({
            theme: 'bootstrap4',
            dropdownParent: $("#test_items"),
            placeholder: "Select Departments",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            allowClear: Boolean($(this).data('allow-clear')),
        });
        $( function() {
            $('#receive_date').datepicker();
        });
        $( function() {
            $('#start_date').datepicker();
        });
        $( function() {
            $('#dead_line_date').datepicker();
        });

        $(document).on('click', '.save_button', function(event) {
            event.preventDefault();
            var error = 0;
            // if ($('#commonModal').find('form').hasClass('schedule_type')) {
            //     $('.error_name').hide();
            //     if ($('#commonModal').find('form').find('input[name="name"]').val().trim() == '') {
            //         $('.error_name').show();
            //         error = 1;
            //     }

            //     if (error == 0) {
            //         let formdata = new FormData($('#commonModal').find('form')[0]);

            //         $.ajax({
            //                 url: $('#commonModal').find('form').attr('action'),
            //                 data: formdata,
            //                 processData: false,
            //                 contentType: false,
            //                 type: 'POST',
            //                 success: function(response) {


            //                     if (response.success === true) {
            //                         toastr.success(response.message, 'Success.');
            //                         $('[name="opd_schedule_types_id"]').append(
            //                             `<option value="${response.data.id}" selected>${response.data.name}</option>`
            //                             );
            //                         $('[name="opd_schedule_types_id"]').trigger('change');

            //                         // hide modal
            //                         $('#commonModal').modal('hide');
            //                         $('#commonModal').find('.modal-body').html('');
            //                         setTimeout(function() {
            //                             //  alert('test');
            //                             $('#create').trigger('click');
            //                         }, 1000);
            //                     } else {
            //                         toastr.error(response.message, 'Error!');
            //                     }
            //                 }
            //             })
            //             .fail(function(jqXHR, textStatus, errorThrown) {
            //                 console.log('AJAX request failed:', textStatus, errorThrown);
            //                 toastr.error('An error occurred during the request.', 'Error!');

            //                 // hide modal
            //                 $('#commonModal').modal('hide');
            //                 $('#commonModal').find('.modal-body').html('');
            //             });
            //     }

            // } else if ($('#commonModal').find('form').hasClass('orgazination_department')) {
            //     $('.error_name').hide();
            //     if ($('#commonModal').find('form').find('input[name="name"]').val().trim() == '') {
            //         $('.error_name').show();
            //         error = 1;
            //     }

            //     if (error == 0) {
            //         let formdata = new FormData($('#commonModal').find('form')[0]);

            //         $.ajax({
            //                 url: $('#commonModal').find('form').attr('action'),
            //                 data: formdata,
            //                 processData: false,
            //                 contentType: false,
            //                 type: 'POST',
            //                 success: function(response) {


            //                     if (response.success === true) {
            //                         toastr.success(response.message, 'Success.');
            //                         $('[name="organization_department_id"]').append(
            //                             `<option value="${response.data.id}" selected>${response.data.name}</option>`
            //                             );
            //                         $('[name="organization_department_id"]').trigger('change');
            //                         // hide modal
            //                         $('#commonModal').modal('hide');
            //                         $('#commonModal').find('.modal-body').html('');
            //                         setTimeout(function() {
            //                             //  alert('test');
            //                             $('#create').trigger('click');
            //                         }, 1000);
            //                     } else {
            //                         toastr.error(response.message, 'Error!');
            //                     }
            //                 }
            //             })
            //             .fail(function(jqXHR, textStatus, errorThrown) {
            //                 console.log('AJAX request failed:', textStatus, errorThrown);
            //                 toastr.error('An error occurred during the request.', 'Error!');

            //                 // hide modal
            //                 $('#commonModal').modal('hide');
            //                 $('#commonModal').find('.modal-body').html('');
            //             });
            //     }

            // }

        })
        $(document).on('click', '.save_project', function(e) {
            e.preventDefault();

            $('.error_title').hide();
            $('.error_project_type_id').hide();
            $('.error_email').hide();
            var error = 0;

            if ($('select[name="project_type_id"]').val() == null || $('select[name="project_type_id"]').val() == '') {
                $('.error_project_type_id').show();
                error = 1;
            }
            if ($('input[name="title"]').val() == null || $('input[name="title"]').val().trim() ==
                '') {
                $('.error_title').show();
                error = 1;
            }

            if (error == 0) {
                let formdata = new FormData($('#projects')[0]);
                $.ajax({
                        url: "{{ route('projects.update', $project->id) }}",
                        data: formdata,
                        processData: false,
                        contentType: false,
                        type: 'POST',
                        success: function(response) {
                            if (response.success === true) {
                                toastr.success(response.message, 'Success.');
                                window.location.href = "{{ route('projects.index') }}";
                                // Replace with the URL you want to redirect to
                            } else {
                                toastr.error(response.message, 'Error!');
                            }
                        }
                    })
                    .fail(function(jqXHR, textStatus, errorThrown) {
                        console.log('AJAX request failed:', textStatus, errorThrown);
                        toastr.error('An error occurred during the request.', 'Error!');
                    });
            }
            error = 1;
        })
    </script>
@endsection
