<div class="card shadow-none" style="margin-bottom:0.8rem;">
    <div class="card-header d-flex align-items-center justify-content-between">
    @if($page == 'billing')
        <div style="width:100%" class="accordion-item">
            <div class="accordion-header" id="panelsStayOpen-headingTwo">
                <div class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false" aria-controls="panelsStayOpen-collapseTwo">
                    <div class="col-md-6">
                    @endif
                        <h6 class="mb-0">Total Products in Cart <i class="bi bi-cart"></i> ({!! isset($data['products']) ? count($data['products']) : '0' !!})</h6>
                        @if($page == 'billing')
                    </div>
                </div>
                <div class="col-md-12" align="right">
                    @endif
                    @if ($id > 0)
                    <a href="{!! route('purchase-edit-cart-billing', $id) !!}" type="button" class="btn btn-outline-primary" id="checkout"><i class="bx bx-plus"></i> Add New</a>
                    @elseif($page != 'billing')
                    <a href="{!! route('purchase-cart-billing') !!}" type="button" class="btn btn-outline-primary" id="checkout"><i class="bx bx-plus"></i> Add New</a>
                    @endif
                </div>
                @if($page == 'billing')
            </div>
            <div style="" id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse @if($page != 'billing'){{'show'}}@else{{''}}@endif" aria-labelledby="panelsStayOpen-headingTwo">
                <div class="accordion-body">
                    @endif
                    <div class="card-body pb-0">
                        <div class="table-responsive">
                            <table id="example" class="table table-bordered align-middle" style="width:100%">
                                <thead class="table-light">
                                    <tr>
                                        <th class="text-start" style="text-align: right">ITEM NAME</th>
                                        <th style="text-align:right">Details</th>
                                        <th width="10%" style="text-align:right">PACK QTY</th>
                                        <th width="10%" style="text-align:right">LOOSE QTY</th>
                                        <th style="text-align:right">PRICE</th>
                                        <th width="7%" style="text-align:right">DIS.%</th>
                                        <th style="text-align:right">DIS.AMT.</th>
                                        <th style="text-align:right">TAX </th>
                                        {{-- <th>TAX AMOUNT</th> --}}
                                        <th style="text-align:right">AMOUNT</th>
                                        @if($page != 'billing')
                                        <th class="thbutton">Delete</th>
                                        @endif
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $i = 1;
                                    $product_price = 0;
                                    @endphp
                                    @if (isset($data['products']) && count($data['products']) > 0)
                                    @foreach ($data['products'] as $key => $list)
                                    <tr class="cart-products" data-price_id="{!! $list['price_id'] !!}">
                                   
                                        <td class="text-start">
                                            <b>{{ $list['product'] ?? '' }}</b> 
                                            <br>
                                                {{ $list['batch'] ?? '' }},
                                                @if(isset($list['expiry_date']))
                                                    {{ $list['expiry_date'] ?? '' }}
                                                @endif
                                        </td>
                                        @if($page != 'billing')
                                        <td><input type="text" name="product_detail" data-price_id="{{ $list['price_id'] }}" class="form-control bg-white" value="{{ $list['product_detail'] ?? '' }}" placeholder="Details" style="text-align:right"></td>
                                        <td style="padding: 0.375rem 0.1rem;">
                                            <!-- <div class="input-group">
                                                <button style="height: 40px; width: 25px;" type="button" class="btn btn-danger btn-minus" data-price_id="{{ $list['product_id'] }}">-</button> -->
                                                <input type="number" name="main_qty" data-price_id="{{ $list['price_id'] }}" class="form-control bg-white" value="{{ convertDecimelPoint($list['main_qty'] ?? '') }}" placeholder="00.00" style="text-align:right">
                                                <!-- <button style="height: 40px; width: 25px;" type="button" class="btn btn-success btn-plus" data-price_id="{{ $list['product_id'] }}">+</button>
                                            </div> -->
                                        </td>
                                        <td style="padding: 0.375rem 0.1rem;">
                                            <!-- <div class="input-group">
                                            <button style="height: 40px; width: 25px;" type="button" class="btn btn-danger btn-minus-loose" data-price_id="{{ $list['product_id'] }}">-</button> -->
                                                <input type="text" name="loose_qty" data-price_id="{{ $list['price_id'] }}" class="form-control bg-white" value="{{ $list['loose_qty'] ?? '' }}" placeholder="Loose" style="text-align:right">
                                            <!-- <button style="height: 40px; width: 25px;" type="button" class="btn btn-success btn-plus-loose" data-price_id="{{ $list['product_id'] }}">+</button>
                                            </div> -->
                                        </td>
                                        <td><input type="text" name="product_price" data-price_id="{{ $list['price_id'] }}" class="form-control bg-white" value="{{ convertDecimelPoint($list['product_price']) ?? '' }}" placeholder="00.00" style="text-align:right"></td>
                                        <td><input type="text" name="per_discount" data-price_id="{{ $list['price_id'] }}" class="form-control bg-white" value="{{  convertDecimelPoint($list['per_discount'] ?? '') }}" placeholder="00.00" style="text-align:right"></td>
                                        <td><input type="text" name="flat_discount" data-price_id="{{ $list['price_id'] }}" class="form-control bg-white" value="{{ convertDecimelPoint ($list['flat_discount'] ?? '') }}" placeholder="00.00" style="text-align:right"></td>
                                        {{-- @dd($list); --}}
                                        <td style="text-align: center">
                                            {{ $list['tax_per'] ?? '' }}%<br>{{ convertDecimelPoint($list['tax_flat'] ?? '') }}
                                            {{-- <input readonly type="text" name="tax_flat" data-price_id="{{ $list['price_id'] }}" class="form-control bg-white" value="" placeholder="00.00"> --}}
                                        </td>
                                        <td class="text-end"><b>{{ convertDecimelPoint($list['amount'] ?? ($list['amount'] ?? '')) }}</b> <br>
                                        <span style="border-top: 1px solid #aaa;">Rate: {!! convertDecimelPoint($list['product_mrp']) ?? '' !!}</span></td>
                                        <td class="text-center">
                                            <a style="line-height:24px;" data-url="{{ route('purchase-cart-product-remove') }}" data-id="{{ $key }}" data-price_id="{{ $list['price_id'] }}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="left" title="Delete">
                                                <i class="bi bi-trash text-white"></i>
                                            </a>
                                        </td>
                                        @else
                                        <td>{{ $list['product_detail'] ?? '' }}</td>
                                        <td class="text-end">
                                           {{ convertDecimelPoint($list['main_qty'] ?? '') }}
                                        </td>
                                        <td class="text-end">
                                          {{ $list['loose_qty'] ?? '' }}
                                        </td>
                                        <td class="text-end">{{ convertDecimelPoint($list['product_price']) ?? '' }}</td>
                                        <td class="text-end">{{  convertDecimelPoint($list['per_discount'] ?? '') }}</td>
                                        <td class="text-end">{{ convertDecimelPoint ($list['flat_discount'] ?? '') }}</td>
                                        
                                        <td class="text-end">
                                            {{ $list['tax_per'] ?? '' }}%<br>{{ convertDecimelPoint($list['tax_flat'] ?? '') }}
                                        </td>
                                        <td class="text-end"><b>{{ convertDecimelPoint($list['amount'] ?? ($list['amount'] ?? '')) }}
                                        </b> <br>
                                        <span style="border-top: 1px solid #aaa;">Rate: {!! convertDecimelPoint($list['product_mrp']) ?? '' !!}</span>
                                        </td>
                                        @endif

                                        @php $product_price += preg_replace("/[^0-9.]/", "", $list['amount']); @endphp
                                    </tr>
                                    @php $i++; @endphp
                                    @endforeach
                                    @else
                                    <tr>
                                        <td colspan="9">No Data Found</td>
                                    </tr>
                                    @endif

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            @if($page == 'billing')
        </div>
    </div>
</div>
@endif
<script type="text/javascript">
    $(document).ready(function() {
        $('#checkout').html('Total Amount {!! convertDecimelPoint($product_price) !!} <i class="bi bi-cart-fill"></i> Checkout')
    });
</script>
@if ($product_price > 0)
<script type="text/javascript">
    $(document).ready(function() {
        $('#checkout').removeClass('btn-outline-primary');
        $('#checkout').addClass('btn-primary');
    });

    $(document).ready(function() {
        // Handle minus button click
        $('.btn-minus').on('click', function() {
            var inputField = $(this).closest('td').find('input[name="main_qty"]');
            var currentValue = parseFloat(inputField.val()) || 0;
            if (currentValue > 0) {
                inputField.val(currentValue - 1);
                updateCartQuantity(inputField.data('price_id'), currentValue - 1);
            }
        });

        // Handle plus button click
        $('.btn-plus').on('click', function() {
            var inputField = $(this).closest('td').find('input[name="main_qty"]');
            var currentValue = parseFloat(inputField.val()) || 0;
            inputField.val(currentValue + 1);
            updateCartQuantity(inputField.data('price_id'), currentValue + 1);
        });


        // Handle minus button click
        $('.btn-minus-loose').on('click', function() {
            var inputField = $(this).closest('td').find('input[name="loose_qty"]');
            var currentValue = parseFloat(inputField.val()) || 0;
            if (currentValue > 0) {
                inputField.val(currentValue - 1);
                updateCartLooseQuantity(inputField.data('price_id'), currentValue - 1);
            }
        });

        // Handle plus button click
        $('.btn-plus-loose').on('click', function() {
            var inputField = $(this).closest('td').find('input[name="loose_qty"]');
            var currentValue = parseFloat(inputField.val()) || 0;
            inputField.val(currentValue + 1);
            updateCartLooseQuantity(inputField.data('price_id'), currentValue + 1);
        });

    });
</script>
@endif