@extends('layouts.app')
@section('title','Doctor Display')
@section('pages')
<style type="text/css">
  .breadcrumb-title {
    border-right: none;
  }

  tr td {
    vertical-align: middle !important;
  }
</style>

<link rel="stylesheet" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css') }}" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">

<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
  <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Doctor Display</div>

  <div class="ms-auto">
    <div class="btn-group">
      <button type="button" class="btn btn-info" id="searchProductStockListModal" data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bi bi-search"></i> Stock Status</button> &nbsp;
      <a href="{{route('queue-manager.index')}}" class="btn btn-outline-secondary me-2"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
    </div>
  </div>
</div>
<!--end breadcrumb-->

<div class="card style_table shadow-none radius-5 min-height">
  <div class="card-header py-3">
    @include('layouts.partials.nav-menu')
    <div class="card style_table">
      <div class="card-body pt-2 ps-3" style="border-radius:0px;">
        <div class="row gx-2 custom_grid align-items-end gx-0 mt-4 mb-3">
          <div class="col-lg-2 col-md-2 col-2">
            <div class="input-group">
              <label class="form-label">Chamber <span class="text-danger"><b></b></span></label>
              <input type="hidden" id="doctor_ac_id" name="doctor_ac_id" value="{!! $doctor->getAccount->id??'' !!}">
              <select class="form-control br-0" id="chamber" name="chamber" required>
                <option value="">Select Chamber</option>
                @foreach($chambers as $chamber)
                <option value="{{$chamber->id}}" {!! $chamber->is_default== 1?'selected':'' !!}>{{$chamber->name}}</option>
                @endforeach
              </select>
            </div>
          </div>
          <div class="col-lg-2 col-md-2 col-2">
            <div class="input-group">
              <label class="form-label">Appointment Date <span class="text-danger"><b></b></span></label>
              <input class="form-control" type="text" id="date" name="date" placeholder="dd/mm/YY" value="">
            </div>
          </div>
          <div class="col-lg-3 col-md-3 col-3">
            <div class="input-group">
              <label class="form-label">Shift Type <span class="text-danger"><b></b></span></label>
              <select class="form-select" id="shift_id" name="shift_id" aria-controls="example">
                <option value="all">All Shift</option>
                @foreach ($shifts as $key => $record)
                <option value="{!! $record->id !!}">{!! $record->name !!}</option>
                @endforeach
              </select>
            </div>
          </div>
          <div class="col-lg-2 col-md-2 col-2">
            <div class="input-group">
              <label class="form-label">Status <span class="text-danger"><b></b></span></label>
              <select class="form-select" id="status" name="status" aria-controls="example">
                <option value="Pending" selected>Pending</option>
                <option value="done">Done</option>
              </select>
            </div>
          </div>
          <div class="col-lg-3 col-md-3 col-3 text-end">
            <button class="btn btn-primary" id="submit" type="button" style="height: 40px; width: 100% !important;"><i class="bi bi-search"></i> Search</button>
          </div>
        </div>
      </div>

    </div>
    <!-- <div class="row mt-2">
     
    </div> -->

    <div class="card-body" id="print_div">
      <div class="row" id="tables">
        @include('queue-manager.doctor-display-table')
      </div>
    </div>
    <script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
    <script>
      $('[name="date"]').datepicker({
        format: "{!! $companyDateFormate??'dd-mm-yyyy' !!}",
        autoclose: true,
        //startDate: financialYearDates.fromDate,//optional
        //endDate: financialYearDates.toDate//optional
      }).datepicker("setDate", new Date());
      $(document).ready(function() {

        function fetch_data(status, shift_id, doctor_ac_id, date, chamber_id) {
          $.ajax({
            url: "?status=" + status + "&shift_id=" + shift_id + "&doctor_ac_id=" + doctor_ac_id + "&date=" + date + "&chamber_id=" + chamber_id,
            success: function(data) {
              $('#tables').html('');
              $('#tables').html(data);
              $(document).ready(function() {
                $.switcher();
              });
            }
          })
        }


        $("body").on("click", '#submit', function(event) {
          var status = $('#status').val();
          var shift_id = $('#shift_id').val();
          var doctor_ac_id = $('#doctor_ac_id').val();
          var date = $('#date').val();
          var chamber_id = $('#chamber').val();


          fetch_data(status, shift_id, doctor_ac_id, date, chamber_id);
        });

        function submitform() {
          $("#submit").trigger("click")
        }
        setInterval(submitform, 10000);


        /*********change status**********/
        $("body").on("click", '.changeStatusCustom', function(event) {
          dataString = {
            "id": $(this).data('id'),
            "status": $(this).data('status')
          };
          var UrlValue = $(this).data('url');
          var status = $(this).data('status');
          var changeStatus = $(this);
          var btn = $(this);

          Swal.fire({
            title: 'Are you sure you want to change status?',
            icon: 'warning',
            showDenyButton: true,
            showCancelButton: false,
            confirmButtonText: 'Yes',
            denyButtonText: 'No',
          }).then((result) => {
            if (result.isConfirmed) {
              $.ajax({
                url: UrlValue,
                method: 'post',
                data: dataString,
                headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                beforeSend: function(xhr) {
                  // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                },
                success: function(response) {
                  if (response.success) {
                    var ErroMsg = $(this).printErrorMsg(response.message);
                    $(this).Toastshow('success', ErroMsg);

                    submitform();
                  } else {
                    var ErroMsg = $(this).printErrorMsg(response.message);
                    if (ErroMsg === '') {
                      ErroMsg = "Something went wrong!";
                    }
                    $(this).Toastshow('error', ErroMsg);
                  }
                },
                error: function(data) {
                  console.log("error ", data);
                }
              });
            } else if (result.isDenied) {
              submitform();
            }
            //return false;
          });
          //return false;
        });



        /*********change status**********/
        $("body").on("click", '.serviceDone', function(event) {
          dataString = {
            "id": $(this).data('id'),
            "status": $(this).data('status')
          };
          var UrlValue = $(this).data('url');
          var status = $(this).data('status');
          var changeStatus = $(this);
          var btn = $(this);

          $.ajax({
            url: UrlValue,
            method: 'post',
            data: dataString,
            headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            beforeSend: function(xhr) {
              // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
            },
            success: function(response) {
              if (response.success) {
                var ErroMsg = $(this).printErrorMsg(response.message);
                $(this).Toastshow('success', ErroMsg);

                submitform();
              } else {
                var ErroMsg = $(this).printErrorMsg(response.message);
                if (ErroMsg === '') {
                  ErroMsg = "Something went wrong!";
                }
                $(this).Toastshow('error', ErroMsg);
              }
            },
            error: function(data) {
              console.log("error ", data);
            }
          });

          //return false;
        });
        //return false

      });


      $(document).on('click', '#searchProductStockListModal', function() {
        $('#commonModalLabel').text('Stock Status');
        $(".modal-dialog").addClass("modal-lg");
        $('.save_button').hide();
        var url = `{!! route('product-search-stock-modal') !!}`;
        $.ajax({
          url: url,
          success: function(data) {
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
          }
        });
      });
    </script>
    @endsection