<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Doctor Name</th>
                <th>Qualification</th>
                <th class="text-center">Doctor Display</th>
                <th class="text-center">Patient Display</th>
            </tr>
        </thead>
        <tbody>
            @if(count($doctors)>0)
            @foreach($doctors as $key => $doctor)
            <tr>
                <td>{{$key+1}}</td>
                <td>
                    <strong>Dr. {!! $doctor->getAccount?$doctor->getAccount->name:'' !!}</strong>
                </td>
                <td>{!! $doctor->getAccount->account_contact?Str::limit($doctor->getAccount->account_contact->qualifications,60):'' !!}</td>
                <td>
                    <div class="btn-group" style="width: 100%">
                        <a href="{{ route('queue-manager.doctor.display', ['doctor_id' => $doctor->id]) }}" class="btn btn-success" style="color: white">View Appointment</a>
                    </div>
                </td>
                <td>
                    <div class="btn-group" style="width: 100%">
                        <a href="{{ route('queue-manager.patient.display', ['doctor_id' => $doctor->id]) }}" class="btn btn-success" style="color: white">View Appointment</a>
                    </div>
                </td>
            </tr>
            @endforeach
            @else
            <tr>
                <td colspan="5">No Data Found</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>

<nav class="float-start mt-2">
    <ul class="pagination">
        {!! $doctors->onEachSide(0)->render('queue-manager.pagination') !!}
    </ul>
</nav>