@extends('layouts.app')
@section('title','Agent Referral list')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<!--breadcrumb-->
<div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
  <div class="breadcrumb-title col-md-6"> Agent Referral list
  </div>
  <div class="col-md-6">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb justify-content-md-end mb-0">
        <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="11" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
        <li class="breadcrumb-item" aria-current="page">Settings</li>
        <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Agent Referral list</li>
      </ol>
    </nav>
  </div>
</div>
<!--end breadcrumb-->

<div class="card style_table shadow-none radius-5 min-height">
  <div class="card-header py-3">
    @include('layouts.partials.nav-menu')

    <div class="row gx-2 align-items-end gx-0 mt-4 mb-3">

      <div class="col-lg-2 col-md-2 col-2 custom_grid">
        <div class="input-group">
          <label class="form-label">Month-Year <span class="text-danger"><b></b></span></label>
          <input type="month" name="month_year" class="month_year form-control " style="cursor: pointer;" placeholder="Month" value="{!! $month !!}">
        </div>
      </div>

      <div class="col-lg-2 col-md-2 col-2 custom_grid">
        <div class="input-group">
          <label class="form-label">Search Agent <span class="text-danger"><b></b></span></label>
          <input type="text" name="search_agent" id="search_agent" class="search_agent  form-control" placeholder="Search agent">
          <input type="hidden" name="agent_id" id="agent_id" value="">
        </div>
      </div>

      <div class="col-lg-1 col-md-1 col-1">
          <button class="btn btn-success btn-lg search-filters" type="button">Search</button>
      </div>
      <!-- <div class="col-lg-2 col-md-2 col-2">
          <button class="btn btn-primary btn-lg store-incentive" type="button">Generate Incentive</button>
      </div> -->

      <div class="col-lg-7 col-md-7">
        <div class="ms-auto float-md-end">
          <div class="btn-group">
              <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
          </div>
        </div>
      </div>
    </div>
  </div>

   <div class="card-body" id="tables">

    @include('referral-vouchers.agent-list.table')

    <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
    <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
    <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
  </div>
  @endsection
  @section('js')
  <script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
  <script>
      $( function() {
        $('.datepickers').datepicker();
      });
     /***************** Global Delay Fucntion ***************/
     function delay(callback, ms) {
        var timer = 0;
        return function() {
            var context = this,
                args = arguments;
            clearTimeout(timer);
            timer = setTimeout(function() {
                callback.apply(context, args);
            }, ms || 0);
        };
    }

      $(document).ready(function(){

        $('#search_agent').autocomplete({
            autoFocus: true,
            minLength: 0,
            source: function(request, response) {
                if (request.term.length < 2) {
                    $('[name="agent_id"]').val('');
                    return false;
                }

                $.ajax({
                    url: "{{ route('search-referral-agents') }}",
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        search_text: request.term
                    },
                    success: function(json) {
                        if (json.error) {
                            $('[name="agent_id"]').val('');
                            return false;
                        }
                        response($.map(json.result, function(item) {
                            return {
                                id: item.id,
                                name: item.name,
                            };
                        }));
                    }
                });
            },
            select: function(event, ui) {
                event.preventDefault();

                $(this).val(ui.item.name);
                $('[name="search_agent"]').val(ui.item.name);
                $('[name="agent_id"]').val(ui.item.id);
                return false;
            }
        }).data("ui-autocomplete")._renderItem = function(ul, item) {
            return $("<li>")
                .append("<a>" + item.name +  "</a>")
                .appendTo(ul);
        };

        function clear_icon(){
          $('#id_icon').html('');
          $('#post_title_icon').html('');
        }
        function fetch_data(page, sort_type, sort_by, query){
          var month_year = $('.month_year').val();
          var agent_id = $('[name="agent_id"]').val();

          $.ajax({
            url:"?page="+page+"&sortby="+sort_by+"&sorttype="+sort_type+"&query="+query+"&month_year="+month_year+"&agent_id="+agent_id,
            success:function(data){
              $('#tables').html('');
              $('#tables').html(data);
              $(document).ready(function(){$.switcher();});
            }
          })
        }

          /******** Change Like below ********/
        $(document).on('keyup', '#search', delay(function() {
            var query = $('#search').val();

            if (query.length < 2 && query.length != 0) {
                return;
            }

            var column_name = $('.sorting').val();
            var sort_type = $('#hidden_sort_type').val();
            var page = 1 ? 1 : (this).attr('href').split('page=')[1];
            fetch_data(page, sort_type, column_name, query);
        }, 700));
        
        $('body').on('change', '.sorting', function(){

          var column_name = $(this).val();
          console.log('perpage',column_name);
          var order_type = $(this).data('sorting_type');
          var reverse_order = '';
          var page = 1?1:(this).attr('href').split('page=')[1];
          var query = $('#search').val()?$('#search').val():'';
          fetch_data(page, reverse_order, column_name, query);
        });
        $('body').on('click', '.pager a', function(event){
          event.preventDefault();
          console.log('url', $(this).attr('href'));
          var page = $(this).attr('href').split('page=')[1];
          $('#hidden_page').val(page);
          var column_name = $('.sorting').val()?$('.sorting').val():'';
          var sort_type = $('#hidden_sort_type').val();
          var query = $('#search').val()?$('#search').val():'';
          $('li').removeClass('active');
          $(this).parent().addClass('active');
          fetch_data(page, sort_type, column_name, query);
        });

        $('body').on('click', '.search-filters', function(event){

          var start_date = $('.start_date').val();
          var end_date   = $('.end_date').val();
          var collection   = $('.collection').val();

          if(start_date != '' && end_date != '') {
            var page        = $('#hidden_page').val();
            var column_name = $('.sorting').val();
            var sort_type   = $('#hidden_sort_type').val();
            var query       = $('#search').val()?$('#search').val():'';

            fetch_data(page, sort_type, column_name, query);
          } else {
            toastr.error('From and to dates are required!');
          }
        });
      });
  </script>
@endsection
