@extends('layouts.app')
@section('title','Dr Referral list')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<!--breadcrumb-->
<div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
  <div class="breadcrumb-title col-md-6"> Dr Referral list
  </div>
  <div class="col-md-6">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb justify-content-md-end mb-0">
        <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="11" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
        <li class="breadcrumb-item" aria-current="page">Settings</li>
        <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Dr Referral list</li>
      </ol>
    </nav>
  </div>
</div>
<!--end breadcrumb-->

<div class="card style_table shadow-none radius-5 min-height">
  <div class="card-header py-3">
    @include('layouts.partials.nav-menu')

    <div class="row gx-2 align-items-end gx-0 mt-4 mb-3">

      <div class="col-lg-2 col-md-2 col-2 custom_grid">
        <div class="input-group">
          <label class="form-label">Doctor <span class="text-danger"><b></b></span></label>
          <select class="form-control br-0 doctor" id="doctor" name="doctor" required>
            <option value="">Select Doctor</option>
            @foreach($doctor as $key => $value)
              <option value="{!! $value->id !!}">{!! $value->name !!}</option>
            @endforeach
          </select>
        </div>
      </div>
      {{-- <div class="col-lg-2 col-md-2 col-2 custom_grid">
        <div class="input-group">
          <label class="form-label">Business Divisions <span class="text-danger"><b></b></span></label>
          <select class="form-control br-0 doctor" id="division" name="division" required>
            <option value="">Select Doctor</option>
            @foreach($divisions as $key => $value)
              <option value="{!! $value->id !!}">{!! $value->name !!}</option>
            @endforeach
          </select>
        </div>
      </div>--}}

      <div class="col-lg-2 col-md-2 col-2 custom_grid">
        <div class="input-group">
          <label class="form-label">Month-Year <span class="text-danger"><b></b></span></label>
          <input type="month" name="month_year" class="month_year form-control " style="cursor: pointer;" placeholder="Month">
        </div>
      </div>

      <div class="col-lg-1 col-md-1 col-1">
          <button class="btn btn-success btn-lg search-filters" type="button">Search</button>
      </div>
      <div class="col-lg-2 col-md-2 col-2">
          <button class="btn btn-primary btn-lg store-incentive" type="button">Generate Incentive</button>
      </div>

      <div class="col-lg-5 col-md-5">
        <div class="ms-auto float-md-end">

          <div class="btn-group">
              <a href="{!! route('referral-vouchers.index') !!}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
          </div>
        </div>
      </div>
    </div>
  </div>

   <div class="card-body" id="tables">

    @include('referral-vouchers.commission.table')

    <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
    <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
    <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
  </div>
  @endsection
  @section('js')
  <script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
  <script>
      $( function() {
        $('.datepickers').datepicker();
      });
     /***************** Global Delay Fucntion ***************/
      function delay(callback, ms) {
        var timer = 0;
        return function() {
            var context = this,
                args = arguments;
            clearTimeout(timer);
            timer = setTimeout(function() {
                callback.apply(context, args);
            }, ms || 0);
        };
      }

      $(document).ready(function(){

        function clear_icon(){
          $('#id_icon').html('');
          $('#post_title_icon').html('');
        }
        function fetch_data(page, sort_type, sort_by, query){
          var month_year = $('.month_year').val();
          var collection   = $('.collection').val();
          var doctor   = $('.doctor').val();

          if (month_year != '') {
            $.ajax({
              url:"?page="+page+"&sortby="+sort_by+"&sorttype="+sort_type+"&query="+query+"&month_year="+month_year+"&collection="+collection+"&doctor="+doctor,
              success:function(data){
                $('#tables').html('');
                $('#tables').html(data);
                $(document).ready(function(){$.switcher();});
              }
            })
          } else {
            toastr.error('Month and Year field are required!');
          }
        }

          /******** Change Like below ********/
        $(document).on('keyup', '#search', delay(function() {
            var query = $('#search').val();

            if (query.length < 2 && query.length != 0) {
                return;
            }

            var column_name = $('.sorting').val();
            var sort_type = $('#hidden_sort_type').val();
            var page = 1 ? 1 : (this).attr('href').split('page=')[1];
            fetch_data(page, sort_type, column_name, query);
        }, 700));
        
        $('body').on('change', '.sorting', function(){

          var column_name = $(this).val();
          console.log('perpage',column_name);
          var order_type = $(this).data('sorting_type');
          var reverse_order = '';
          var page = 1?1:(this).attr('href').split('page=')[1];
          var query = $('#search').val()?$('#search').val():'';
          fetch_data(page, reverse_order, column_name, query);
        });
        $('body').on('click', '.pager a', function(event){
          event.preventDefault();
          console.log('url', $(this).attr('href'));
          var page = $(this).attr('href').split('page=')[1];
          $('#hidden_page').val(page);
          var column_name = $('.sorting').val()?$('.sorting').val():'';
          var sort_type = $('#hidden_sort_type').val();
          var query = $('#search').val()?$('#search').val():'';
          $('li').removeClass('active');
          $(this).parent().addClass('active');
          fetch_data(page, sort_type, column_name, query);
        });

        $('body').on('click', '.search-filters', function(event){

          var month_year = $('.month_year').val();
          var collection   = $('.collection').val();

          if(month_year != '') {
            var page        = $('#hidden_page').val();
            var column_name = $('.sorting').val();
            var sort_type   = $('#hidden_sort_type').val();
            var query       = $('#search').val()?$('#search').val():'';

            fetch_data(page, sort_type, column_name, query);
          } else {
            toastr.error('Month and Year field are required!');
          }
        });
        $(document).on('click', '.store-incentive', function(event){

          var month_year = $('.month_year').val();
          var division   = $('[name="division"]').val();
          var doctor   = $('.doctor').val();

          if(month_year == '') {
            toastr.error('Month and Year field are required!');
          } else {
            $.ajax({
              url: '{{ route("referral-vouchers.store") }}',
                type: 'POST',
                dataType: 'JSON',
                data: {
                    "_token"     : $('meta[name="csrf-token"]').attr('content'),
                    "month_year" : month_year,
                    "division"   : division,
                    "doctor"     : doctor
                },
                success: function(json) {
                    toastr.success('Referral Voucher generated successfully.');
                }
            });
          }
        });
      });
  </script>
@endsection
