@extends('layouts.app')
@section('title','Referral Voucher')
@section('pages')
<style type="text/css">
    .add_btn {
        height: 30px; width: 30px; border-radius: 100%; padding: 0
    }
</style>
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Referral Voucher</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Referral Voucher</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('referral-vouchers.index')}}" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width" action="{{ route('referral-vouchers.update', $voucher->id)}}" method="post" enctype='multipart/form-data' id="product_form">
                        <!-- For validation comment on -->
                        <!-- <form class="row g-3 was-validated"> -->
                        @csrf
                        @method('PUT')
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Product Details</h5>
                                    <hr class="mb-0">
                                    <div class="col-md-6">
                                        <input type="hidden" name="redirect_url" value="{{request()->type??''}}">
                                        <div>
                                            <label for="name" class="form-label">From Date <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="from_date" class="from_date form-control datepickers" readonly="" style="cursor: pointer;" placeholder="From Date" value="{{ date('m/d/Y', strtotime($voucher->from_date)) }}">
                                        </div>
                                        <span class="text-danger error_name" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="short_name" class="form-label">To Date</label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="to_date" class="to_date form-control datepickers" readonly="" style="cursor: pointer;" placeholder="To Date" value="{{ date('m/d/Y', strtotime($voucher->to_date)) }}">
                                        </div>
                                        <span class="text-danger error_short_name" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-12">
                                        <div>
                                            <label class="form-label">Business Divisions <span class="text-danger"><b></b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select class="form-control br-0" id="division" name="division" required>
                                                <option value="">Select Doctor</option>
                                                @foreach($divisions as $key => $value)
                                                  <option value="{!! $value->id !!}" {!! matchSelected($value->id, old('division', $voucher->getDetail->Bussiness_divission_id)) !!}>{!! $value->name !!}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    {{-- <div class="col-md-6">
                                        <div>
                                            <label class="form-label">Revenue Amount <span class="text-danger"><b></b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="revenue_amount" class="revenue_amount form-control" style="cursor: pointer;" placeholder="To Date" value="{{$voucher->getDetail->revenue_amount}}">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label class="form-label">Incentive Amount <span class="text-danger"><b></b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="incentive_amount" class="incentive_amount form-control" style="cursor: pointer;" placeholder="To Date" value="{{$voucher->getDetail->incentive_amount}}">
                                        </div>
                                    </div> --}}

                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                          <button class="btn btn-primary" type="submit"><i class="bx bx-save"></i> Update</button>
                                      </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                  </form>
              </div>
          </div>
      </div>
  </div>
</div>
<!--end row-->
@endsection

@section('js')

<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
<script>
    $( function() {
        $('.datepickers').datepicker();
    });
</script>
@endsection
