@extends('layouts.app')
@section('title','Referral Voucher')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>

  <!--breadcrumb-->
  <div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Referral Voucher</div>
    <div class="ms-auto">
      @if (in_array('referral-vouchers-create', $authRolePermissions))
      <div class="btn-group">
        <a href="{!! route('referral-vouchers.create') !!}" class="btn btn-success" ><i class="bx bx-plus"></i> Add New</a>
      </div>
      @endif
      <div class="btn-group">
          <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
      </div>
    </div>
  </div>
   <!--end breadcrumb-->

  <div class="card shadow-none radius-5 min-height">
    <div class="card-header py-3">
      @include('layouts.partials.nav-menu')
     <div class="row g-3">
        <div class="col-lg-3 col-md-6 me-auto">
         <div class="ms-auto position-relative">
           <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
           <input class="form-control ps-5" type="search" id="search" placeholder="Search">
         </div>
        </div>
        <!-- <div class="col-lg-2 col-6 col-md-3">
          <select class="form-select">
            <option>Status: Show All</option>
            <option>Status: Active</option>
            <option>Status: Disabled</option>
            <option>Status: Pending</option>
          </select>
        </div> -->
        <!-- <div class="col-lg-2 col-6 col-md-3 dataTables_length" id="example_length">
           <select class="form-select sorting" id="" name="example_length" aria-controls="example">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
          </select>
        </div> -->
      </div>
    </div>
    <div class="card-body" id="tables">
      
      @include('referral-vouchers.table')
      
      <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
      <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
      <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
    </div>

  <script>
    $(document).ready(function(){
      function clear_icon(){
        $('#id_icon').html('');
        $('#post_title_icon').html('');
      }

      function fetch_data(page, sort_type, sort_by, query){
        $.ajax({
          url:"?page="+page+"&sortby="+sort_by+"&sorttype="+sort_type+"&query="+query,
          success:function(data){
            $('#tables').html('');
            $('#tables').html(data);
            $(document).ready(function(){$.switcher();});
          }
        })
      }

      $(document).on('click', '#create', function(){
        $('#commonModalLabel').text('Add New Referral Voucher');
        $('.save_button_span').text('Save Referral Voucher');
        $.ajax({
          url:"{!! route('address-types.create') !!}",
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
          }
        })
      })

      $(document).on('click', '.edit', function(){
        $('#commonModalLabel').text('Edit Referral Voucher');
        $('.save_button_span').text('Update Referral Voucher');
        var id = $(this).data('id');
        var url = `{!! route('address-types.edit', ':id') !!}`.replace(':id', id);

        $.ajax({
          url:url,
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
          }
        })
      })

      $(document).on('click', '.save_button', function(event){
        event.preventDefault();
        $('.error_name').hide();
        $('.error_code').hide();
        $('.error_priority').hide();
        var error = 0;

        if ($('#commonModal').find('form').find('input[name="name"]').val().trim() == '') {
          $('.error_name').show();
          error = 1;
        }
        if ($('#commonModal').find('form').find('input[name="code"]').val().trim() == '') {
          $('.error_code').show();
          error = 1;
        }
        if ($('#commonModal').find('form').find('input[name="priority"]').val().trim() == '') {
          $('.error_priority').show();
          error = 1;
        }

        if (error == 0) {
          $('#commonModal').find('form').submit();
        }
        error = 1;
      })

      $('body').on('keyup change input', '#search', function(){
        var query       = $('#search').val();
        
        if (query.length < 2 && query.length != 0) {
          return;
        }

        var column_name = $('.sorting').val();
        var sort_type   = $('#hidden_sort_type').val();
        var page        = 1?1:(this).attr('href').split('page=')[1];
        fetch_data(page, sort_type, column_name, query);
      });

      $('body').on('change', '.sorting', function(){
        var column_name   = $(this).val();
        var order_type    = $(this).data('sorting_type');
        var reverse_order = '';
        var page          = 1?1:(this).attr('href').split('page=')[1];
        var query         = $('#search').val()?$('#search').val():'';
        fetch_data(page, reverse_order, column_name, query);
      });

      $('body').on('click', '.pager a', function(event){
        event.preventDefault();
        $('#hidden_page').val(page);
        var page        = $(this).attr('href').split('page=')[1];
        var column_name = $('.sorting').val()?$('.sorting').val():'';
        var sort_type   = $('#hidden_sort_type').val();
        var query       = $('#search').val()?$('#search').val():'';
        $('li').removeClass('active');
        $(this).parent().addClass('active');
        fetch_data(page, sort_type, column_name, query);
      });
    });
  </script>
@endsection