@extends('layouts.app')
@section('title','Dr Referral list')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<!--breadcrumb-->
<div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
  <div class="breadcrumb-title col-md-6"> Dr Referral list
  </div>
  <div class="col-md-6">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb justify-content-md-end mb-0">
        <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="11" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
        <li class="breadcrumb-item" aria-current="page">Settings</li>
        <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Dr Referral list</li>
      </ol>
    </nav>
  </div>
</div>
<!--end breadcrumb-->

<div class="card style_table shadow-none radius-5 min-height">
  <div class="card-header py-3">
    @include('layouts.partials.nav-menu')

    <div class="row gx-2 align-items-end gx-0 mt-2 mb-2">

      <div class="col-lg-5 col-md-5 col-5 custom_grid">
        <h6>{!! $voucher->doctor !!} ({!! $voucher->doctor_code !!})</h6>

        <p>{!! formatedDate($voucher->from_date) !!} - {!! formatedDate($voucher->to_date) !!}</p>
      </div>
      <div class="col-lg-3 col-md-3 col-4 dataTables_length" id="example_length">
        <form id="typeForm">
          <i class="bi bi-funnel"></i>
          <select class="form-select" id="statement_by" name="statement_by" aria-controls="example">
              <option value="product" {!! $statement_by == 'product' ? 'selected' : '' !!}>Statement By Product</option>
              <option value="patient" {!! $statement_by == 'patient' ? 'selected' : '' !!}>Statement By Patient</option>
          </select>
        </form>
      </div>

      <div class="col-lg-4 col-md-4">
        <div class="ms-auto float-md-end">

          <div class="btn-group">
              <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
          </div>
        </div>
      </div>
    </div>
  </div>

   <div class="card-body" id="print_div">

    <div class="pathology-bill">
        <div class="row">
          <div class="col-2" style="width: 20%">
              <p>Date : {!! formatedDate(date('Y-m-d')) !!}</p>
          </div>
          <div class="col-7" style="text-align: center;">
              <p style="font-size: 14px;"><b>Doctor Referral STATEMENT</b></p>
              <p style="padding-bottom: 5px;font-size: 11px;"><b><span style="color: #698aff;">Referral</span> List</b>
              <b>From <span style="color:#698aff;" id="">{{formatedDate($voucher->from_date)}}</span> TO <span style="color:#698aff;" id="">{{formatedDate($voucher->to_date)}}</span>
                      </b></p>
          </div>
          <div class="col-2" style="text-align: right; width:20%">
              <p>Time : {!! formatedTime(date('H:i:s')) !!}</p>
          </div>
        </div>
        @include('referral-vouchers.print.table')
      </div>

    <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
    <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
    <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
  </div>
  <div class="row">
    <div class="col-md-6" style="text-align: right;">
        <button id="btn_print" type="button" class="btn btn-primary btn-lg"><i class="bi bi-printer text-white"></i> Print Statement </button>
    </div>

  </div>
@endsection
@section('js')
  <script>
    $(document).ready(function() {
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            printInvoice();
            return;
        });
        $(document).on('change', '#statement_by', function(event) {
            event.preventDefault();
            $('#typeForm').submit();
            return;
        });

    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content = window.open('', '', 'height=750px,width=960px');
        let doc = content.document;
        let head = doc.head;
        let body = doc.body;

        $(head).append('<Title>Doctor Referral Voucher</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }

  </script>
@endsection
