<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Voucher No</th>
                <th>Consultant</th>
                <th>From Date</th>
                <th>To Date</th>
                <th>Revenue Amount</th>
                <th>Incentive Amount</th>

                @if (in_array('referral-vouchers-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if (in_array('referral-vouchers-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td>{{ $data->firstItem() + $key }}</td>
                        <td>{{ $list->voucher_no }}<br>
                            {{ formatedDate(@$list->incentive_date) }}
                        </td>
                        <td>{{ $list->account_title }} {{ ucfirst($list->consultant_name) }}</td>
                        <td>{{ formatedDate(@$list->from_date) }}</td>
                        <td>{{ formatedDate(@$list->to_date) }}</td>
                        <td>{{ $list->revenue_amount }}</td>
                        <td>{{ $list->incentive_amount }}</td>
                        <td>
                            <a href="{{ route('referral-vouchers.print',$list->id) }}" class="btn btn-warning">
                                <i class="bi bi-pencil-square text-print"></i>
                            </a>
                        </td>
                        @if (in_array('referral-vouchers-edit', $authRolePermissions))
                        <td>
                            <a href="{{ route('referral-vouchers.edit',$list->id) }}" class="btn btn-warning">
                                <i class="bi bi-pencil-square text-white"></i>
                            </a>
                        </td>
                        @endif
                        @if (in_array('referral-vouchers-delete', $authRolePermissions))
                        <td>
                            <a data-url="{{ route('referral-vouchers.destroy',$list->id) }}" data-id="{{$list->id}}" class="btn btn-danger deleteData" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="5">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="mt-2 row">
    <div class="col-lg-10 col-md-10 col-10 float-start">
        {!! $data->onEachSide(0)->render('enquiry-statuses.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <!-- <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i> -->
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10" {!! matchSelected('10',$sort_by) !!}>Show: 10</option>
            <option value="30" {!! matchSelected('30',$sort_by) !!}>Show: 30</option>
            <option value="50" {!! matchSelected('50',$sort_by) !!}>Show: 50</option>
        </select>
    </div>
</nav>
