@extends('layouts.app')
@section('title','Role')
@section('pages')
<style type="text/css">
    .modules-card-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    .more-less {
        float: right;
        color: #212121;
    }
</style>

<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Settings</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Add Role & Permission</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('roles.index')}}" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class="card shadow-none radius-5 min-height">
            <div class="card-body">
                <div class="">
                    <form class="row g-3 auto-width" action="{{ route('roles.store')}}" method="post" enctype='multipart/form-data'>
                        <!-- For validation comment on -->
                        <!-- <form class="row g-3 was-validated"> -->
                            @csrf
                            <div class="col-md-4 px-2">
                                <label for="validationCustom01" class="form-label">Role Name</label>
                                <input type="text" class="form-control" placeholder="Enter Name" name="name" value="" required>
                                @if ($errors->has('name'))
                                <span class="text-danger">{{ $errors->first('name') }}</span>
                                @endif
                            </div>
                            <div class="col-md-4 mt-5 d-sm-flex">
                                <h5 class="pe-2">All Permissions</h5>
                                <input type="checkbox" class='admin' class="form-control" id="check-all">
                            </div>
                            <div class="col-md-4">
                                <label for="searchInput" class="form-label">Search</label>
                                <input type="text" id='searchInput' class="form-control" placeholder="Search by module name">
                            </div>
                            <div class="accordion row mt-2" id="accordionExample">
                                @foreach($modules as $key => $module)
                                    <div class="col-md-12 modules-main-div" title="{!! strtolower($module->menu_name) !!}">
                                        <div class="card">
                                            <div class="card-header modules-card-header" id="sliders">
                                                <h5 class="mb-0" style="width:92%">
                                                    <p class="collapser " type="button" data-toggle="collapse" href="#multiCollapseExample{!! $key !!}" data-bs-toggle="collapse" aria-controls="multiCollapseExample{!! $key !!}">
                                                        <i class="more-less bi bi-plus h3" style="margin-top: 7px;"></i>
                                                        {!! ucfirst($module->menu_name) !!}
                                                    </p>
                                                </h5>
                                                <input type="checkbox" value="asd" class="parent-checkbox">
                                            </div>
                                            <div id="multiCollapseExample{!! $key !!}" class="collapse multi-collapse">
                                                <div class="card-body row">
                                                    @foreach($module->permissions as $permission)
                                                    <div class="col-xl-3 col-md-3 col-sm-3 float-left mt-2">
                                                        <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" class='admin'> {{ formatPermissionsText($permission->name) }}
                                                    </div>
                                                    @endforeach
                                                     @if(isset($module->childModules))
                                                        @foreach($module->childModules as $child_key => $child_module)
                                                            <div class="col-md-12 mt-2">
                                                                <div class="card">
                                                                    <div class="card-header modules-card-header" id="sliders">
                                                                        <h6 class="mb-0">
                                                                            <p class="" type="button" data-toggle="collapse" href="#multiCollapseExampleChild{!! $child_key !!}" data-bs-toggle="collapse" aria-controls="multiCollapseExampleChild{!! $child_key !!}">
                                                                                {!! ucfirst($child_module->menu_name) !!}
                                                                            </p>
                                                                        </h6>
                                                                        <input type="checkbox" value="asd" class="parent-checkbox">
                                                                    </div>
                                                                    <div id="multiCollapseExampleChild{!! $child_key !!}" class="collapse multi-collapse">
                                                                        <div class="card-body row">
                                                                            @foreach($child_module->permissions as $child_permission)
                                                                            <div class="col-xl-3 col-md-3 col-sm-3 float-left mt-2">
                                                                                <input type="checkbox"  name="permission[{{ $child_permission->name }}]"  value="{{ $child_permission->name }}"> {{ formatPermissionsText($child_permission->name) }}
                                                                            </div>
                                                                            @endforeach
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endforeach
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach

                                {{-- <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-header" id="sliders">
                                            <h5 class="mb-0">
                                                <p class="" type="button" data-toggle="collapse" href="#multiCollapseUsers" data-bs-toggle="collapse" aria-controls="multiCollapseUsers">
                                                    Users
                                                </p>
                                            </h5>
                                        </div>
                                        <div id="multiCollapseUsers" class="collapse multi-collapse">
                                            <div class="card-body row">
                                                @foreach(nameByPermisson('Users') as $permission)
                                                <div class="col-xl-6 col-md-6 col-sm-6 float-left mt-2">
                                                    <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" class='admin'> {{ $permission->name }}
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-header" id="sliders">
                                            <h5 class="mb-0">
                                                <p class="" type="button" data-toggle="collapse" href="#multiCollapseCompany" data-bs-toggle="collapse" aria-controls="multiCollapseCompany">
                                                    Company
                                                </p>
                                            </h5>
                                        </div>
                                        <div id="multiCollapseCompany" class="collapse multi-collapse">
                                            <div class="card-body row">
                                                @foreach(nameByPermisson('Company') as $permission)
                                                <div class="col-xl-6 col-md-6 col-sm-6 float-left mt-2">
                                                    <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" class='admin'> {{ $permission->name }}
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-header" id="sliders">
                                            <h5 class="mb-0">
                                                <p class="" type="button" data-toggle="collapse" href="#multiCollapseBucket" data-bs-toggle="collapse" aria-controls="multiCollapseBucket">
                                                    Bucket
                                                </p>
                                            </h5>
                                        </div>
                                        <div id="multiCollapseBucket" class="collapse multi-collapse">
                                            <div class="card-body row">
                                                @foreach(nameByPermisson('Bucket') as $permission)
                                                <div class="col-xl-6 col-md-6 col-sm-6 float-left mt-2">
                                                    <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" class='admin'> {{ $permission->name }}
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-header" id="sliders">
                                            <h5 class="mb-0">
                                                <p class="" type="button" data-toggle="collapse" href="#multiCollapseFinancialYear" data-bs-toggle="collapse" aria-controls="multiCollapseFinancialYear">
                                                Financial Year</p>
                                            </h5>
                                        </div>
                                        <div id="multiCollapseFinancialYear" class="collapse multi-collapse">
                                            <div class="card-body row">
                                                @foreach(nameByPermisson('Financial Year') as $permission)
                                                <div class="col-xl-6 col-md-6 col-sm-6 float-left mt-2">
                                                    <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" class='admin'> {{ $permission->name }}
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-header" id="sliders">
                                            <h5 class="mb-0">
                                                <p class="" type="button" data-toggle="collapse" href="#multiCollapseSMS" data-bs-toggle="collapse" aria-controls="multiCollapseSMS">
                                                SMS Api</p>
                                            </h5>
                                        </div>
                                        <div id="multiCollapseSMS" class="collapse multi-collapse">
                                            <div class="card-body row">
                                                @foreach(nameByPermisson('SMS Template') as $permission)
                                                <div class="col-xl-6 col-md-6 col-sm-6 float-left mt-2">
                                                    <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" class='admin'> {{ $permission->name }}
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>



                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-header" id="sliders">
                                            <h5 class="mb-0">
                                                <p class="" type="button" data-toggle="collapse" href="#multiCollapseCategory" data-bs-toggle="collapse" aria-controls="multiCollapseCategory">
                                                Library category</p>
                                            </h5>
                                        </div>
                                        <div id="multiCollapseCategory" class="collapse multi-collapse">
                                            <div class="card-body row">
                                                @foreach(nameByPermisson('Library category') as $permission)
                                                <div class="col-xl-6 col-md-6 col-sm-6 float-left mt-2">
                                                    <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" class='admin'> {{ $permission->name }}
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-header" id="sliders">
                                            <h5 class="mb-0">
                                                <p class="" type="button" data-toggle="collapse" href="#libraryAuthors" data-bs-toggle="collapse" aria-controls="libraryAuthors">
                                                Library Author</p>
                                            </h5>
                                        </div>
                                        <div id="libraryAuthors" class="collapse multi-collapse">
                                            <div class="card-body row">
                                                @foreach(nameByPermisson('Library Author') as $permission)
                                                <div class="col-xl-6 col-md-6 col-sm-6 float-left mt-2">
                                                    <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" class='admin'> {{ $permission->name }}
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-header" id="sliders">
                                            <h5 class="mb-0">
                                                <p class="" type="button" data-toggle="collapse" href="#libraryPublisher" data-bs-toggle="collapse" aria-controls="libraryPublisher">
                                                Library Publisher</p>
                                            </h5>
                                        </div>
                                        <div id="libraryPublisher" class="collapse multi-collapse">
                                            <div class="card-body row">
                                                @foreach(nameByPermisson('Library Publisher') as $permission)
                                                <div class="col-xl-6 col-md-6 col-sm-6 float-left mt-2">
                                                    <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" class='admin'> {{ $permission->name }}
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-header" id="sliders">
                                            <h5 class="mb-0">
                                                <p class="" type="button" data-toggle="collapse" href="#libraryBookLanguages" data-bs-toggle="collapse" aria-controls="libraryBookLanguages">
                                                Library Book Language</p>
                                            </h5>
                                        </div>
                                        <div id="libraryBookLanguages" class="collapse multi-collapse">
                                            <div class="card-body row">
                                                @foreach(nameByPermisson('Library Book Language') as $permission)
                                                <div class="col-xl-6 col-md-6 col-sm-6 float-left mt-2">
                                                    <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" class='admin'> {{ $permission->name }}
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-header" id="sliders">
                                            <h5 class="mb-0">
                                                <p class="" type="button" data-toggle="collapse" href="#libraryTags" data-bs-toggle="collapse" aria-controls="libraryTags">
                                                Library Tags</p>
                                            </h5>
                                        </div>
                                        <div id="libraryTags" class="collapse multi-collapse">
                                            <div class="card-body row">
                                                @foreach(nameByPermisson('Library Tags') as $permission)
                                                <div class="col-xl-6 col-md-6 col-sm-6 float-left mt-2">
                                                    <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" class='admin'> {{ $permission->name }}
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-header" id="sliders">
                                            <h5 class="mb-0">
                                                <p class="" type="button" data-toggle="collapse" href="#libraryPlaces" data-bs-toggle="collapse" aria-controls="libraryPlaces">
                                                Library Places</p>
                                            </h5>
                                        </div>
                                        <div id="libraryPlaces" class="collapse multi-collapse">
                                            <div class="card-body row">
                                                @foreach(nameByPermisson('Library Places') as $permission)
                                                <div class="col-xl-6 col-md-6 col-sm-6 float-left mt-2">
                                                    <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" class='admin'> {{ $permission->name }}
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-header" id="sliders">
                                            <h5 class="mb-0">
                                                <p class="" type="button" data-toggle="collapse" href="#libraryEditors" data-bs-toggle="collapse" aria-controls="libraryEditors">
                                                Library Editor</p>
                                            </h5>
                                        </div>
                                        <div id="libraryEditors" class="collapse multi-collapse">
                                            <div class="card-body row">
                                                @foreach(nameByPermisson('Library Editor') as $permission)
                                                <div class="col-xl-6 col-md-6 col-sm-6 float-left mt-2">
                                                    <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" class='admin'> {{ $permission->name }}
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-header" id="sliders">
                                            <h5 class="mb-0">
                                                <p class="" type="button" data-toggle="collapse" href="#libraryTranslator" data-bs-toggle="collapse" aria-controls="libraryTranslator">
                                                Library Translator</p>
                                            </h5>
                                        </div>
                                        <div id="libraryTranslator" class="collapse multi-collapse">
                                            <div class="card-body row">
                                                @foreach(nameByPermisson('Library Translator') as $permission)
                                                <div class="col-xl-6 col-md-6 col-sm-6 float-left mt-2">
                                                    <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" class='admin'> {{ $permission->name }}
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div> --}}

                            </div>
                        <div class="col-12">
                            <!-- <button class="btn btn-light me-2" type="reset"><i class="bx bx-revision ms-0 me-1"></i>Clear</button> -->
                            <button class="btn btn-primary" type="submit"><i class="bx bx-save"></i> Save Role and Permissions</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
<!--end row-->
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function() {
            $('.card').each(function() {
                var headerCheckbox = $(this).find('.card-header input[type="checkbox"]');
                var bodyCheckboxes = $(this).find('.card-body input[type="checkbox"]');

                var anyCheckboxNotChecked = false;

                bodyCheckboxes.each(function() {
                    if (!$(this).is(':checked')) {
                        anyCheckboxNotChecked = true;
                        return false; // Exit the loop since we found a checked checkbox
                    }
                });

                if (anyCheckboxNotChecked == false && bodyCheckboxes.length > 0) {
                    headerCheckbox.prop('checked', true);
                    $(this).find('.ui-switcher').attr('aria-checked', true);
                }
            });
        });
        $(document).on('input', '#searchInput', function() {
            var searchText = $(this).val().toLowerCase();

            $('.modules-main-div').each(function() {
                var title = $(this).attr('title').toLowerCase();
                if (title.includes(searchText)) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
        $(document).on('change', '.parent-checkbox', function() {
            var parent = $(this).parent().parent();

            if ($(this).is(':checked')) {
                parent.find('.card-body input[type="checkbox"]').prop('checked', true);
                parent.find('.ui-switcher').attr('aria-checked', true);
            } else {
                parent.find('.card-body input[type="checkbox"]').prop('checked', false);
                parent.find('.ui-switcher').attr('aria-checked', false);
            }
        })
        $(document).on('change', '#check-all', function() {
            var parent = $(this).parent().parent();
            console.log(parent);
            if ($(this).is(':checked')) {
                parent.find('input[type="checkbox"]').prop('checked', true);
                parent.find('.ui-switcher').attr('aria-checked', true);
            } else {
                parent.find('input[type="checkbox"]').prop('checked', false);
                parent.find('.ui-switcher').attr('aria-checked', false);
            }
        })

        $(document).on('click', '.collapser', function() {
            if ($(this).hasClass('collapsed')) {
                $(this).find('.more-less').removeClass('bi-dash');
                $(this).find('.more-less').addClass('bi-plus');
            } else {
                $(this).find('.more-less').removeClass('bi-plus');
                $(this).find('.more-less').addClass('bi-dash');
            }
        });
    </script>
@endsection
