@extends('layouts.app')
@section('title','Role')
@section('pages')
<style type="text/css">
    .modules-card-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    .more-less {
        float: right;
        color: #212121;
    }
</style>

<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Settings</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Role & Permission</li>
                <li class="breadcrumb-item" aria-current="page"> For {{ $role->name }}</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('roles.index')}}" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class="card shadow-none radius-5 min-height">
            <div class="card-body">
                <div class="">
                    <form class="row g-3 auto-width" action="{{ route('roles.update',$role)}}" method="post" enctype='multipart/form-data'>
                        <!-- For validation comment on -->
                        <!-- <form class="row g-3 was-validated"> -->
                            @csrf
                            @method('patch')
                            <div class="col-md-8 px-4 mt-5 d-sm-flex">
                                <h5 class="pe-2">All Permissions</h5>
                                <input type="checkbox" class='admin' class="form-control" id="check-all" checked>
                            </div>
                            <div class="col-md-4">
                                <label for="searchInput" class="form-label">Search</label>
                                <input type="text" id='searchInput' class="form-control" placeholder="Search by module name">
                            </div>
                            <div class="accordion row mt-2" id="accordionExample">
                                @foreach($modules as $key => $module)
                                    <div class="col-md-12 modules-main-div" title="{!! strtolower($module->menu_name) !!}">
                                        <div class="card">
                                            <div class="card-header modules-card-header" id="sliders">
                                                <h5 class="mb-0" style="width:92%">
                                                    <p class="collapser " type="button" data-toggle="collapse" href="#multiCollapseExample{!! $key !!}" data-bs-toggle="collapse" aria-controls="multiCollapseExample{!! $key !!}">
                                                        <i class="more-less bi bi-plus h3" style="margin-top: 7px;"></i>
                                                        {!! ucfirst($module->menu_name) !!}
                                                    </p>
                                                </h5>
                                                <input type="checkbox" value="asd" class="parent-checkbox">
                                            </div>
                                            <div id="multiCollapseExample{!! $key !!}" class="collapse multi-collapse">
                                                <div class="card-body row">
                                                    @foreach($module->permissions as $permission)
                                                    <div class="col-xl-3 col-md-3 col-sm-3 float-left mt-2">
                                                        {{ formatPermissionsText($permission->name) }} <input type="checkbox"  name="permission[{{ $permission->name }}]"  value="{{ $permission->name }}" {{ in_array($permission->name, $rolePermissions) ? 'checked': '' }}>
                                                    </div>
                                                    @endforeach
                                                    @if(isset($module->childModules))
                                                        @foreach($module->childModules as $child_key => $child_module)
                                                            <div class="col-md-12 mt-2">
                                                                <div class="card">
                                                                    <div class="card-header modules-card-header" id="sliders">
                                                                        <h6 class="mb-0" style="width:92%">
                                                                            <p class="collapser " type="button" data-toggle="collapse" href="#multiCollapseExampleChild{!! $child_key !!}" data-bs-toggle="collapse" aria-controls="multiCollapseExampleChild{!! $child_key !!}">
                                                                                <i class="more-less bi bi-plus h3" style="margin-top: 7px;"></i>
                                                                                {!! ucfirst($child_module->menu_name) !!}
                                                                            </p>
                                                                        </h6>
                                                                        <input type="checkbox" value="asd" class="parent-checkbox">
                                                                    </div>
                                                                    <div id="multiCollapseExampleChild{!! $child_key !!}" class="collapse multi-collapse">
                                                                        <div class="card-body row">
                                                                            @foreach($child_module->permissions as $child_permission)
                                                                            <div class="col-xl-3 col-md-3 col-sm-3 float-left mt-2">
                                                                                <input type="checkbox"  name="permission[{{ $child_permission->name }}]"  value="{{ $child_permission->name }}" {{ in_array($child_permission->name, $rolePermissions) ? 'checked': '' }}> {{ formatPermissionsText($child_permission->name) }}
                                                                            </div>
                                                                            @endforeach
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endforeach
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        <div class="col-12">
                            <button class="btn btn-primary" type="submit"><i class="bx bx-save"></i> Update Permissions</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
<!--end row-->
@endsection
@section('js')
    <script type="text/javascript">
        $(document).on('input', '#searchInput', function() {
            var searchText = $(this).val().toLowerCase();

            $('.modules-main-div').each(function() {
                var title = $(this).attr('title').toLowerCase();
                if (title.includes(searchText)) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
        $(document).ready(function() {
            $('#accordionExample .card').each(function() {
                var headerCheckbox = $(this).find('.card-header input[type="checkbox"]');
                var bodyCheckboxes = $(this).find('.card-body input[type="checkbox"]');

                var anyCheckboxNotChecked = false;

                bodyCheckboxes.each(function() {
                    if (!$(this).is(':checked')) {
                        anyCheckboxNotChecked = true;
                        return false; // Exit the loop since we found a checked checkbox
                    }
                });

                if (anyCheckboxNotChecked == false) {
                    headerCheckbox.prop('checked', true);
                    $(this).find('.ui-switcher').attr('aria-checked', true);
                }
            });

            $('#accordionExample .card').each(function() {
                var headerCheckbox = $(this).find('.card-header input[type="checkbox"]');
                var bodyCheckboxes = $(this).find('.card-body input[type="checkbox"]');

                var anyCheckboxNotChecked = false;

                bodyCheckboxes.each(function() {
                    if (!$(this).is(':checked') && ! $(this).is("#check-all") ) {
                        anyCheckboxNotChecked = true;
                        return false; // Exit the loop since we found a checked checkbox
                    }
                });

                if (anyCheckboxNotChecked == false) {
                    headerCheckbox.prop('checked', true);
                    $(this).find('.ui-switcher').attr('aria-checked', true);
                } else {
                    $('#check-all').prop('checked', false);
                    $('#check-all').parent().find('.ui-switcher').attr('aria-checked', false);
                }
            });
        });
        $(document).on('change', '.parent-checkbox', function() {
            var parent = $(this).parent().parent();

            if ($(this).is(':checked')) {
                parent.find('.card-body input[type="checkbox"]').prop('checked', true);
                parent.find('.ui-switcher').attr('aria-checked', true);
            } else {
                parent.find('.card-body input[type="checkbox"]').prop('checked', false);
                parent.find('.ui-switcher').attr('aria-checked', false);
            }
        })
        $(document).on('change', '#check-all', function() {
            var parent = $(this).parent().parent();
            console.log(parent);
            if ($(this).is(':checked')) {
                parent.find('input[type="checkbox"]').prop('checked', true);
                parent.find('.ui-switcher').attr('aria-checked', true);
            } else {
                parent.find('input[type="checkbox"]').prop('checked', false);
                parent.find('.ui-switcher').attr('aria-checked', false);
            }
        })

        $(document).on('click', '.collapser', function() {
            if ($(this).hasClass('collapsed')) {
                $(this).find('.more-less').removeClass('bi-dash');
                $(this).find('.more-less').addClass('bi-plus');
            } else {
                $(this).find('.more-less').removeClass('bi-plus');
                $(this).find('.more-less').addClass('bi-dash');
            }
        });
    </script>
@endsection
