@extends('layouts.app')
@section('title','Sale Return')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
    tr td {
     vertical-align: middle !important; 
}
.error {
        border: solid red 1px;
    }
</style>



  <!--breadcrumb-->
  <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
    <div class="breadcrumb-title col-md-6"> Sale Return
    </div>
    <div class="col-md-6">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb justify-content-md-end mb-0">
          <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="28" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
          <li class="breadcrumb-item" aria-current="page">Sale Return</li>
        </ol>
      </nav>
    </div>
  </div>
  <!--end breadcrumb-->

  <div class="card style_table shadow-none radius-5 min-height">
    <div class="card-header py-3">
      @include('layouts.partials.nav-menu')
      <div class="row gx-2">

        <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
          <i class="bi bi-funnel"></i>
          <select class="form-select" id="" name="search_type" aria-controls="example">
              <option value="invoice_no">Invoice No</option>
              <option value="pat_name">Name</option>
              <option value="phone">Phone Number</option>
              <option value="abha_no">UHID/ABHA NO</option>
          </select>
        </div>

        <div class="col-lg-3 col-md-3 col-8">
            <div class="position-relative">
                <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                <input class="form-control ps-5" type="search" id="search" placeholder="Search" autofocus>
            </div>
        </div>


        <div class="col-lg-7 col-md-7">
          <div class="ms-auto float-md-end">

            <!-- <div class="btn-group">
                <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
            </div> -->

           <div class="btn-group">
              @if(in_array('sale-return-create', $authRolePermissions))
                <a class="btn btn-primary" id="create" data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bi bi-plus-circle"></i> New Sale Return</a>
              @endif
            </div>
            <div class="btn-group">
              <ul class="navbar-nav align-items-center">
                  <li class="nav-item dropdown dropdown-small me-0">
                      <a class="dropdown-toggle dropdown-toggle-nocaret btn btn-secondary" href="#"
                          data-bs-toggle="dropdown">
                          <div class="">
                             <i class="bi bi-receipt"></i> Statement
                          </div>
                      </a>
                      <ul class="dropdown-menu dropdown-menu-end bg-secondary text-white px-0">
                          <li>
                              <a href="{{ route('sale-return.statement') }}" class="py-2 dropdown-item text-white hover-dark"><i class="bi bi-receipt"></i> Invoice Wise Statement</a>
                          </li>
                          <li>
                              <a href="{{ route('sale-return-item-wise.statement') }}" class="py-2 dropdown-item text-white hover-dark"><i class="bi bi-receipt"></i> Item Wise Statement</a>
                          </li>
                      </ul>
                  </li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="card-body" id="tables">

      @include('sale-returns.table')

      <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
      <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
      <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
    </div>

    
  <script>

     /***************** Global Delay Fucntion ***************/
     function delay(callback, ms) {
        var timer = 0;
        return function() {
            var context = this,
                args = arguments;
            clearTimeout(timer);
            timer = setTimeout(function() {
                callback.apply(context, args);
            }, ms || 0);
        };
    }

    $(document).ready(function(){
      function clear_icon(){
        $('#id_icon').html('');
        $('#post_title_icon').html('');
      }

      function fetch_data(page, sort_type, sort_by, query){
        var search_type = $('[name="search_type"]').val();

        $.ajax({
          url:"?page="+page+"&sortby="+sort_by+"&sorttype="+sort_type+"&query="+query+"&search_type="+search_type,
          success:function(data){
            $('#tables').html('');
            $('#tables').html(data);
            $(document).ready(function(){$.switcher();});
          }
        })
      }

     /******** searching ********/
     $(document).on('keyup', '#search', delay(function() {
        var query = $('#search').val();

        if (query.length < 2 && query.length != 0) {
            return;
        }

        var column_name = $('.sorting').val();
        var sort_type   = $('#hidden_sort_type').val();
        var page        = 1 ? 1 : (this).attr('href').split('page=')[1];
        fetch_data(page, sort_type, column_name, query);
    }, 700));


      $('body').on('change', '.sorting', function(){
        var column_name   = $(this).val();
        var order_type    = $(this).data('sorting_type');
        var reverse_order = '';
        var page          = 1?1:(this).attr('href').split('page=')[1];
        var query         = $('#search').val()?$('#search').val():'';
        fetch_data(page, reverse_order, column_name, query);
      });

      $('body').on('click', '.pager a', function(event){
        event.preventDefault();
        $('#hidden_page').val(page);
        var page        = $(this).attr('href').split('page=')[1];
        var column_name = $('.sorting').val()?$('.sorting').val():'';
        var sort_type   = $('#hidden_sort_type').val();
        var query       = $('#search').val()?$('#search').val():'';
        $('li').removeClass('active');
        $(this).parent().addClass('active');
        fetch_data(page, sort_type, column_name, query);
      });

      /*********delete data**********/
      $("body").on("click",'.deleteDataCustom', function(event){
          dataString    = {"id":$(this).data('id')};
          var UrlValue  = $(this).data('url');
          var btn = $(this);

          Swal.fire({
              title: 'Are you sure you want to delete this?',
              icon: 'warning',
              showDenyButton: true,
              showCancelButton: false,
              confirmButtonText: 'Yes',
              denyButtonText: 'No',
          }).then((result) => {
              /* Read more about isConfirmed, isDenied below */
              if (result.isConfirmed) {
                  $.ajax({
                  url     : UrlValue,
                  method  : 'post',
                  data    :{
                          "_token": $('meta[name="csrf-token"]').attr('content'),
                          "id": $(this).data('id')
                  },
                  headers:
                  {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  },
                  beforeSend: function( xhr ) {
                      // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                  },
                  success : function(response){
                      if(response.success){
                          var ErroMsg = $(this).printErrorMsg(response.message);

                          $(this).Toastshow('success',ErroMsg);

                          var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                          var column_name = $('.sorting').val()?$('.sorting').val():'';
                          var sort_type   = $('#hidden_sort_type').val();
                          var query       = $('#search').val()?$('#search').val():'';

                          fetch_data(page, sort_type, column_name, query);
                      }else{
                          var ErroMsg = $(this).printErrorMsg(response.message);
                          $(this).Toastshow('error',ErroMsg);
                      }
                  },
                  error: function (data) {
                    console.log("error ",data);
                  }
              });
              }
          });
      });

      /*********change status**********/
      $("body").on("click",'.changeStatusCustom', function(event){
          dataString       = {"id":$(this).data('id'),"status":$(this).data('status')};
          var UrlValue     = $(this).data('url');
          var status       = $(this).data('status');
          var changeStatus = $(this);
          var btn = $(this);

          Swal.fire({
              title: 'Are you sure you want to change status?',
              icon: 'warning',
              showDenyButton: true,
              showCancelButton: false,
              confirmButtonText: 'Yes',
              denyButtonText: 'No',
          }).then((result) => {
              if (result.isConfirmed) {
                  $.ajax({
                      url     : UrlValue,
                      method  : 'post',
                      data    :dataString,
                      headers:
                      {
                          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                      },
                      beforeSend: function( xhr ) {
                          // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                      },
                      success : function(response){
                          if(response.success){
                              var ErroMsg = $(this).printErrorMsg(response.message);
                              $(this).Toastshow('success',ErroMsg);

                              var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                              var column_name = $('.sorting').val()?$('.sorting').val():'';
                              var sort_type   = $('#hidden_sort_type').val();
                              var query       = $('#search').val()?$('#search').val():'';

                              fetch_data(page, sort_type, column_name, query);
                          } else {
                              var ErroMsg = $(this).printErrorMsg(response.message);
                              if (ErroMsg === '') {
                                  ErroMsg = "Something went wrong!";
                              }
                              $(this).Toastshow('error',ErroMsg);

                              if (status == 1) {
                                  changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                              } else {
                                  changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                              }
                          }
                      },
                      error: function (data) {
                          console.log("error ",data);

                          if (status == 1) {
                              changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                          } else {
                              changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                          }
                      }
                  });
              }
              else if (result.isDenied) {
                  var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                  var column_name = $('.sorting').val()?$('.sorting').val():'';
                  var sort_type   = $('#hidden_sort_type').val();
                  var query       = $('#search').val()?$('#search').val():'';

                  fetch_data(page, sort_type, column_name, query);
              }
              //return false;
          });
      //return false;
      });

      /************************ Sale Invoice Search  *************/
      $(document).on('click', '#create', function() {
          $('#commonModalLabel').text('Search Invoice Number');
          $('.save_button_span').text('Sale Return Invoice');
          $.ajax({
              url: "{!! route('sale-return.search-invoice-from') !!}",
              success: function(data) {
                  $('#commonModal').find('.modal-body').html('');
                  $('#commonModal').find('.modal-body').html(data);
              }
          })
      })



    
    });
  </script>
@endsection
