@extends('layouts.app')
@section('title','Select Sale Return Item')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
    tr td {
     vertical-align: middle !important; 
}
.error {
        border: solid red 1px;
    }
</style>



  <!--breadcrumb-->
  <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
    <div class="breadcrumb-title col-md-6"> Select Sale Return Item
    </div>
    <div class="col-md-6">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb justify-content-md-end mb-0">
          <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="28" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
          <li class="breadcrumb-item" aria-current="page">Select Sale Return Item</li>
        </ol>
      </nav>
    </div>
  </div>
  <!--end breadcrumb-->

  <div class="card style_table shadow-none radius-5 min-height">
    <div class="card-header py-3">
      @include('layouts.partials.nav-menu')
      <div class="row gx-2">

        <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
          <!-- <i class="bi bi-funnel"></i>
          <select class="form-select" id="" name="search_type" aria-controls="example">
              <option value="invoice_no">Invoice No</option>
              <option value="pat_name">Name</option>
              <option value="phone">Phone Number</option>
              <option value="abha_no">UHID/ABHA NO</option>
          </select> -->
        </div>

        <div class="col-lg-3 col-md-3 col-8">
            <!-- <div class="position-relative">
                <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                <input class="form-control ps-5" type="search" id="search" placeholder="Search" autofocus>
            </div> -->
        </div>


        <div class="col-lg-7 col-md-7">
          <div class="ms-auto float-md-end">

            <div class="btn-group">
                <button class="btn btn-success me-1 processToCart"><i class="bi bi-cart-fill ms-0 me-1"></i>Process To Cart</button>
            </div>

           <div class="btn-group">
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="card-body" id="tables">
     @include('sale-returns.item-selection-table')
      <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
      <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
      <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
    </div>

    
  <script>

     /***************** Global Delay Fucntion ***************/
     function delay(callback, ms) {
        var timer = 0;
        return function() {
            var context = this,
                args = arguments;
            clearTimeout(timer);
            timer = setTimeout(function() {
                callback.apply(context, args);
            }, ms || 0);
        };
    }

    $(document).ready(function(){
      function clear_icon(){
        $('#id_icon').html('');
        $('#post_title_icon').html('');
      }

        // var page        = 1?1:(this).attr('href').split('page=')[1];
        // var column_name = $('.sorting').val()?$('.sorting').val():'';
        // var sort_type   = $('#hidden_sort_type').val();
        // var query       = $('#search').val()?$('#search').val():'';
        // fetch_data(page, sort_type, column_name, query);


      function fetch_data(page, sort_type, sort_by, query){
        var search_type = $('[name="search_type"]').val();

        $.ajax({
          url:"?page="+page+"&sortby="+sort_by+"&sorttype="+sort_type+"&query="+query+"&search_type="+search_type,
          success:function(data){
            $('#tables').html('');
            $('#tables').html(data);
            $(document).ready(function(){$.switcher();});
          }
        })
      }

     /******** searching ********/
     $(document).on('keyup', '#search', delay(function() {
        var query = $('#search').val();

        if (query.length < 2 && query.length != 0) {
            return;
        }

        var column_name = $('.sorting').val();
        var sort_type   = $('#hidden_sort_type').val();
        var page        = 1 ? 1 : (this).attr('href').split('page=')[1];
        fetch_data(page, sort_type, column_name, query);
    }, 700));


      $('body').on('change', '.sorting', function(){
        var column_name   = $(this).val();
        var order_type    = $(this).data('sorting_type');
        var reverse_order = '';
        var page          = 1?1:(this).attr('href').split('page=')[1];
        var query         = $('#search').val()?$('#search').val():'';
        fetch_data(page, reverse_order, column_name, query);
      });

      $('body').on('click', '.pager a', function(event){
        event.preventDefault();
        $('#hidden_page').val(page);
        var page        = $(this).attr('href').split('page=')[1];
        var column_name = $('.sorting').val()?$('.sorting').val():'';
        var sort_type   = $('#hidden_sort_type').val();
        var query       = $('#search').val()?$('#search').val():'';
        $('li').removeClass('active');
        $(this).parent().addClass('active');
        fetch_data(page, sort_type, column_name, query);
      });
    
    });

    // $('.processToCart').on('click', function() {
    //     // Manually trigger form submission via AJAX
    //     $('#addToCartForm').submit();
    // });

    $('.processToCart').on('click', function(e) {
        e.preventDefault(); 
        var id ='{!! $sale_invoice->id !!}';
            var formData = $('#addToCartForm').serializeArray();
            var redirectUrl = `{!! route('sale-return.create', ':id') !!}`.replace(':id', id);
            $.ajax({
                url: $('#addToCartForm').attr('action'),
                data: formData,
                type: 'POST',
                success: function (response) {
                        if (response.success === true) {
                            toastr.success(response.message, 'Success.');
                            window.location.href=redirectUrl;
                        } else {
                            toastr.error(response.message, 'Error!');
                        }
                    }
            });
      });
  </script>
@endsection
