<style type="text/css">
    .clear{
    clear:both;
    margin-top: 20px;
    }

    .autocomplete{
        position: relative;
    }
    .ui-autocomplete {
        z-index: 215000000 !important;
        }
    .autocomplete .searchResult{
        list-style: none;
        padding: 0px;
        width: 78%;
        position: absolute;
        margin: 0;
        margin-top: 40px;
        background: white;
        z-index: 5;
    }

    .autocomplete .searchResult li{
        background: #F2F3F4;
        padding: 10px;
        margin-bottom: 1px;
        white-space: break-spaces;
    }

    .autocomplete .searchResult li:nth-child(even){
        background: #E5E7E9;
        color: black;
    }

    .autocomplete .searchResult li:hover{
        cursor: pointer;
        background: #CACFD2;
    }

    #add_reference i {
        height: 20px;
        width: 20px;
        background: #0d6efd25;
        color: #0d6efd;
        text-align: center;
        border-radius: 50px;
        line-height: 20px;
    }

    .add_btn {
        height: 40px;
        width: 40px;
        font-size:16px;
        border-radius: 0 3.5px 3.5px 0;
        padding: 0;
    }
    .custom_grid {
        padding-left:1rem;
        padding-right:1rem;
    }
    .custom_grid .input-group {
        position:relative;
    }
    .custom_grid .input-group .form-label {
        position:absolute;
        top:-10px;
        left:5px;
        font-size:12px;
        padding:0px 8px;
        background-color:#f7f8fa;
        z-index:5;
    }
    .custom_grid .input-group .form-control.br-0 {
        border-radius:0;
    }
    .custom_grid .btn {
        font-size:22px;
        padding: 0.15rem 0.75rem;
        border-top-left-radius:0px;
        border-bottom-left-radius:0px;
    }
    .select2-container--bootstrap4 .select2-selection {
        border-top-right-radius:0px;
        border-bottom-right-radius:0px;
    }
    .error {
        border: solid red 1px;
    }
</style>
<form class="row g-3 auto-width search-from" action="{{ route('sale-return.search-invoice-store') }}" method="post" enctype='multipart/form-data'
    id="room">
    @csrf

    <!-- FLoor -->
    <div class="col-md-12">
        <div>
            <label for="search_type" class="form-label">Search Type <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
        <select class="form-select" id="search_type" name="search_type" aria-controls="example">
              <option value="invoice_no">Invoice No</option>
              <option value="pat_name">Name</option>
              <option value="phone">Phone Number</option>
          </select>
        </div>
        <span class="text-danger error_search_type" style="display: none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <div>
            <label class="form-label">Invoice Number <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group autocomplete">
            <input type="text" name="" id="invoice_id" class="invoice-select form-control" placeholder="Invoice Number" value="" >
            <ul class="searchResult"></ul>
            <input type="hidden" name="invoice_id" value="">
        </div>
        <span class="text-danger error_invoice_id" style="display:none;">This field is required.</span>
    </div>
    

</form>

<script>
      $(document).ready(function(){
      $('.invoice-select').autocomplete({
            autoFocus: true,
            minLength: 0,
            source: function(request, response) {
                if (request.term.length < 2) {
                    $('[name="invoice_id"]').val('');
                    return false;
                }

                $.ajax({
                    url: "{{ route('sale-return.search-invoice') }}",
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        search_text: request.term,
                        search_type:$('#search_type').val()
                    },
                    success: function(json) {
                        if (json.error) {
                            $('[name="invoice_id"]').val('');
                            return false;
                        }
                        response($.map(json.result, function(item) {
                            return {
                                id: item.id,
                                voucher_type_invoice_no: item.voucher_type_invoice_no,
                                name: item.name,
                                phone_no: item.phone_no,
                            };
                        }));
                    }
                });
            },
            select: function(event, ui) {
                event.preventDefault();
                var phone_no = ui.item.phone_no != null ? ', ' + ui.item.phone_no : '';
                var name = ui.item.name != null ? ', ' + ui.item.name : '';
                $(this).val(ui.item.voucher_type_invoice_no + name + phone_no +"");
                $('[name="invoice_id"]').val(ui.item.id);
                return false;
            }
        }).data("ui-autocomplete")._renderItem = function(ul, item) {
            var phone_no = item.phone_no != null ? ', ' + item.phone_no : '';
            var name = item.name != null ? ', ' + item.name : '';
            return $("<li>")
                .append("<a>" + item.voucher_type_invoice_no + name + phone_no + "</a>")
                .appendTo(ul);
        };
    });


    $(document).on('click','.save_button', function(e) {
        e.preventDefault();

        

        if ($('#commonModal').find('form').hasClass('search-from')) {
           

            $('.error_invoice_id').hide();
            var error = 0;

            
            if ($('[name="invoice_id"]').val().trim() == '') {
              $('.error_invoice_id').show();
              error = 1;
              setTimeout(function () {
                $('.error_invoice_id').hide();
                }, 3000);

            }

            if (error == 0) {
                $('#commonModal').find('form').submit();
            }
        }

        error = 1;
    })
</script>
