@extends('layouts.app')
@section('title','IPD Sale Order Billings')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
        border: none;
    }

    #total_billing {
        border-color: #5cff80;
        background-color: #e0ffe2;
        font-size: 16px;
    }
    .final_total_billing {
        border-color: #5cff80 !important;
        background-color: #e0ffe2 !important;
        font-size: 16px !important;
    }
    #due_balance_amount {
        border-color: #ff7979;
        background-color: #ffe0e0;
        font-size: 16px;
    }

    #amount_recieved {
        border: 2px solid #fff579;
        background-color: #fff;
        font-weight: 600;
        font-size: 16px;
    }

    .amount_collection {
        border: 2px solid #fff579;
        /* background-color: #f9f2df; */
        font-weight: 600;
        font-size: 16px;
    }

</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">

<link rel="stylesheet" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css') }}" rel="stylesheet" />

<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> IPD Sale Order Billings</div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{!! route('ipd-sale-orders.view',['id'=>$id,'batch_id'=>$batch_id]) !!}" class="btn btn-primary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->

<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="row g-3 auto-width">
                    <div class="col-md-12 cart_products">
                    </div>

                    <form class="row auto-width mt-0" action="{{ route('ipd-sale-order.update',['id'=>$id,'batch_id'=>$batch_id])}}" method="post" enctype='multipart/form-data' style="padding: 0px 0px 0px 9px;" id="billing_form">
                        <div class="col-md-6" style="padding: 0 0 0 9px;">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    @csrf
                                    <div class="col-md-4 mt-3">
                                    <h5 class="mb-0">Billing Details</h5>
                                    </div>
                                    {{--<div class="col-md-8 mt-3" style="text-align: right;display: flex; justify-content: space-between;">
                                        <label for="validationCustomOrder" style="margin-top: 5px;margin-left: auto;" class="form-label"><b>Round Off?</b> </label><br>
                                        <input name="round_off" class="form-check-inputFeatured btn-lg round_off" type="checkbox" id="round_off" value="0">
                                    </div>--}}
                                    <hr class="mb-2">
                                    <div class="col-md-6">
                                        <div class="card border shadow-none" style="margin-bottom:0.8rem;">
                                        <div class="card-body py-2">
                                            <div class="d-flex gap-3">
                                            <div class="icon">
                                            <div class="icon-box small_icon bg-light-primary border-0">
                                                <i class="bi bi-person-hearts text-primary"></i>
                                            </div>
                                            <h6 class="text-center mt-1 mb-0"><small>Patient</small></h6>
                                            </div>
                                            <div class="info">
                                                <p class="mb-0">{!! $patients['name'] ?? '' !!}</p>
                                                <p class="mb-0">{!! isset($patients['gender']) && $patients['gender'] != '' ? ' ' . $patients['gender'] : '' !!}{!! isset($patients['date_of_birth']) && $patients['date_of_birth'] != '' ? ', ' . age($patients['date_of_birth']) . ' Years' : '' !!}</p>
                                                <p class="mb-0">{!! isset($patients['phone_no']) && $patients['phone_no'] != '' ? ' ' . $patients['phone_no'] : '' !!}</p>
                                            </div>
                                        </div>
                                        </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="card border shadow-none" style="margin-bottom:0.8rem;">
                                        <div class="card-body py-2">
                                            <div class="d-flex gap-3">
                                            <div class="icon">
                                            <div class="icon-box small_icon bg-light-primary border-0">
                                                <i class="bi bi-person text-primary"></i>
                                            </div>
                                            <h6 class="text-center mt-1 mb-0"><small>Doctor</small></h6>
                                            </div>
                                            <div class="info">
                                                @if(!empty($doctors))
                                                <p class="mb-0">{!! $doctors['name'] ?? '' !!}</p>
                                                <p class="mb-0">{!! isset($doctors['phone_no']) && $doctors['phone_no'] != '' ? ' ' . $doctors['phone_no'] : '' !!}</p>
                                                <p class="mb-0">{!! isset($doctors['gender']) && $doctors['gender'] != '' ? ' ' . $doctors['gender'] : '' !!}{!! isset($doctors['date_of_birth']) && $doctors['date_of_birth'] != '' ? ', ' . $doctors['date_of_birth'] : '' !!}</p>
                                                @else
                                                    <p class="mb-0">Self</p>
                                                @endif
                                            </div>
                                        </div>
                                        </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="invoice_date" class="form-label">Billing Date <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="invoice_date" name="invoice_date" aria-describedby="inputGroupPrepend" required value="{!! formatedDate($data['invoice_date']) !!}">
                                        <span class="text-danger error_invoice_date" style="display: none;">This field is required.</span>
                                    </div>
                                   {{-- <div class="col-md-6">
                                        <div>
                                            <label for="payment_term_id" class="form-label">Payment Term <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select class="single-select form-control" name="payment_term_id">
                                                @foreach($payment_types as $list)
                                                <option value="{{ $list->id }}" {!! isset($data['payment_term_id']) && $data['payment_term_id'] = $list->id ? 'selected' : ($list->is_default == 1 ? 'selected' : '') !!}>{{ $list->payment_term_name }}</option>
                                                @endforeach
                                            </select>
                                        </div> 
                                        <span class="text-danger error_payment_term_id" style="display: none;">This field is required.</span>
                                    </div>
                                     <div class="col-md-6">
                                        <label for="special_case" class="form-label">Payment Mode <span class="text-danger"><b>*</b></span></label>
                                        <div class="input-group">
                                           <select class="single-select form-control" name="payment_mode_id">
                                                @foreach($accounting_group as $list)
                                                <option value="{{ $list->id }}" {!! isset($data['payment_mode_id']) && $data['payment_mode_id'] = $list->id ? 'selected' : ($list->is_payment_mode == 1 ? 'selected' : '') !!}>{{ $list->name }}</option>
                                                @endforeach
                                            </select>
                                        </div> 
                                        <span class="text-danger error_payment_mode_id" style="display: none;">This field is required.</span>
                                    </div>--}}

                                    <div class="col-md-6">
                                        <label for="amount" class="form-label">Total Billing Amount <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="total_billing" readonly value="{!! convertDecimelPoint($data['amount']) !!}" style="text-align: right;">
                                        <span class="text-danger" style="display: none;">This field is required.</span>
                                    </div>
                                {{--<div class="col-md-12">
                                    <div class="table-responsive">
                                        <table id="example" class="table table-bordered align-middle" style="width:100%">
                                            <thead class="table-light">
                                                <tr>
                                                    <th class="text-start">Transaction Mode </th>
                                                    <th class="text-start">Transaction Reference</th>
                                                    <th style="text-align: right;width: 30%">Amount</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if(isset($accounting_group) && count($accounting_group) > 0)
                                                @foreach($accounting_group as $key => $list)
                                                <tr class="cart-products" data-patient_id="{{$list['account_id']}}">
                                                    <td class="text-start">{{$list->name ?? ''}}
                                                    <input type="hidden" class="form-control" name="payment_mode[{!! $list->id !!}][mode_id]" value="{!! $list->id !!}" style="text-align: right;">
                                                    </td>
                                                    <td class="text-start">
                                                        <select class="form-control" name="payment_mode[{!! $list->id !!}][transaction_mode_id]">
                                                            @if(isset($list->chart_of_account_sub_type->paymentModes))
                                                            @foreach($list->chart_of_account_sub_type->paymentModes as $value)
                                                            <option value="{!! $value->id !!}" {!! matchselected($value->is_default, 1) !!}>{!! $value->mode !!}</option>
                                                            @endforeach
                                                            @endif
                                                        </select>
                                                    </td>
                                                    <td style="text-align: center;">
                                                        <input type="number" class="form-control amount amount_collection" name="payment_mode[{!! $list->id !!}][amount]" value="0" style="text-align: right;">
                                                    </td>
                                                </tr>
                                                @endforeach
                                                @else
                                                <tr>
                                                    <td colspan="9">No Data Found</td>
                                                </tr>
                                                @endif
                                                @if($discount_group)
                                                <tr class="cart-products">
                                                    <td class="text-start">
                                                        <input type="hidden" class="form-control" name="discount_account_id" value="{!! $discount_group->id !!}" style="text-align: right;">
                                                    {{$discount_group->name ?? ''}}</td>
                                                    <td class="text-start">
                                                    <select name="discount_type" id="discount_type" class="form-control">
                                                        <option value="FLAT" {!! isset($data['discount_type']) && $data['discount_type'] == 'FLAT' ? 'selected' : '' !!}>FLAT</option>
                                                        <option value="PERCENTAGE" {!! isset($data['discount_type']) && $data['discount_type'] == 'PERCENTAGE' ? 'selected' : '' !!}>%</option>
                                                    </select>
                                                    </td>
                                                    <td style="text-align: center;">
                                                    <input type="text" class="form-control" id="special_discount" value="{!! $data['special_discount'] !!}" name="special_discount" style="text-align: right;">
                                                    </td>
                                                </tr>
                                                @endif

                                                @if($round_off)
                                                <tr class="cart-products round_off_show">
                                                    <td class="text-start">
                                                    {{$round_off->name ?? ''}}</td>
                                                    <td class="text-start">
                                                    <select name="round_off_account_id" id="round_off_account_id" class="form-control">
                                                        <option value="{!! $round_off->id !!}">{!! $round_off->name !!}</option>
                                                    </select>
                                                    </td>
                                                    <td style="text-align: center;">
                                                        <input type="text" class="form-control" id="round_off_amount" value="" name="round_off_amount" style="text-align: right;" readonly>
                                                    </td>
                                                </tr>
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>--}}
                            {{--<div class="col-md-12">
                                        <label for="special_discount" class="form-label">Special Discount</label>
                                        <div class="input-group">
                                            <select name="discount_type" id="discount_type" class="form-control">
                                                <option value="FLAT" {!! isset($data['discount_type']) && $data['discount_type'] == 'FLAT' ? 'selected' : '' !!}>FLAT</option>
                                                <option value="PERCENTAGE" {!! isset($data['discount_type']) && $data['discount_type'] == 'PERCENTAGE' ? 'selected' : '' !!}>%</option>
                                            </select>
                                            <input type="text" class="form-control" id="special_discount" value="{!! $data['special_discount'] !!}" name="special_discount" style="text-align: right;">
                                        </div> 
                                        <span class="text-danger error_special_discount" style="display: none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-12 round_off_show">
                                        <label for="final_total_billing_amount" class="form-label" style="float:right;">Final Total Billing Amount</label>
                                        <input type="text" class="form-control final_total_billing" id="final_total_billing_amount" name="final_total_billing_amount" value="" readonly  style="text-align: right;">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="due_balance_amount" class="form-label">Due Balance Amount</label>
                                        <input type="text" class="form-control" id="due_balance_amount" name="due_balance_amount" value="{!! convertDecimelPoint($data['due_balance_amount']) !!}" readonly style="text-align: right;">
                                        <span class="text-danger error_due_balance_amount" style="display: none;">This field is required.</span>
                                        <span class="text-danger error_due_balance_amount_negative" style="display: none;">Due amount can not be in negative.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="amount_recieved" class="form-label">Amt. Received</label>
                                        <input type="text" class="form-control" value="0" id="amount_recieved" name="amount_recieved" style="text-align: right;">
                                        <span class="text-danger error_amount_recieved" style="display: none;">This field is required.</span>
                                    </div>--}}
                                   
                                    {{--<div class="col-md-6">
                                        <label for="other_charges" class="form-label">Other Charges</label>
                                        <input type="text" class="form-control" id="other_charges" name="other_charges" value="{!! isset($data['other_charges']) ? convertDecimelPoint($data['other_charges']) : '' !!}" placeholder="Other Charges">
                                    </div>--}}
                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                          <button class="btn btn-primary submit"  type="button"><i class="bx bx-save"></i> Submit to Create Final Invoice/Bill</button>
                                      </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6" style="padding: 0 0 0 18px;">
                            
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Additional Details</h5>
                                    <hr class="mb-2">
                                    <!-- <div class="col-md-6">
                                        <label for="special_case" class="form-label">Special Case </label>
                                        <div class="input-group">
                                            <select name="special_case" class="single-select form-control">
                                                @foreach($special_cases as $key => $value)
                                                    <option value="{!! $value->id !!}" {!! isset($data['special_case']) && $data['special_case'] == $value->id ? 'checked' : '' !!}>{!! $value->name !!}</option>
                                                @endforeach
                                            </select>
                                        </div> 
                                    </div>
                                    <div class="col-md-6">
                                        <label for="sample_barcode" class="form-label">Sample Barcode</label>
                                        <input type="text" class="form-control" name="sample_barcode" value="{!! $data['sample_barcode'] ?? '' !!}" placeholder="Sample Barcode">
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="payment_mode" class="form-label">Sample Receive Date </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" id="sample_receive_date" name="sample_receive_date" aria-describedby="inputGroupPrepend" value="{!! $data['sample_receive_date'] !!}">
                                        </div> 
                                    </div>
                                    <div class="col-md-6">
                                        <label for="special_discount" class="form-label">Sample Receive Time</label>

                                        <input type="time" class="form-control" name="sample_receive_time" value="{!! $data['sample_receive_time'] ?? '' !!}">
                                    </div> -->
                                    <div class="col-md-12">
                                        <label for="due_balance_amount" class="form-label">Any Ref. No</label>
                                        <input id="reff_no" class="form-control" type="text" name="reff_no" autocomplete="off" placeholder="Ref. No" value="{!! $data['reff_no'] ?? '' !!}">
                                    </div>
                                    <!-- <div class="col-md-6">
                                        <label for="special_case" class="form-label">Bussiness Source </label>
                                        <div class="input-group">
                                            <select name="bussiness_source" class="single-select form-control">
                                                @foreach($bussiness_source as $key => $value)
                                                    <option value="{!! $value->id !!}" {!! isset($data['bussiness_source']) && $data['bussiness_source'] == $value->id ? 'checked' : (isset($data['bussiness_source']) && $data['bussiness_source'] == $value->id ? 'checked' : '') !!}>{!! $value->enquiry_source_name !!}</option>
                                                @endforeach
                                            </select>
                                        </div> 
                                    </div> -->
                                    <div class="col-md-12">
                                        <label for="sale_remarks" class="form-label">Billing Remarks</label>
                                        <textarea name="sale_remarks" id="sale_remarks" rows="1" class="form-control" autocomplete="off" placeholder="Billing Remarks">{!! $data['sale_remarks'] ?? '' !!}</textarea>
                                    </div>
                                    <!-- <div class="col-md-12">
                                        <label for="sale_remarks" class="form-label">Remarks for Technician</label>
                                        <textarea name="remarks_for_technician" id="remarks_for_technician" rows="1" class="form-control" autocomplete="off" placeholder="Technician Remarks">{!! $data['remarks_for_technician'] ?? '' !!}</textarea>
                                    </div> -->
                                </div>
                            </div>

                           {{-- <div class="col-md-12">
                                <div class="card">
                                    <div class="card-body g-3 row">

                                        <div class="card-header d-flex align-items-center justify-content-between">
                                            <h5>Transactions</h6>
                                        </div>

                                        <div class="table-responsive">
                                            <x-TransactionSummary :transactionSummery="$transactionSummery" :transactionHistory="$transactionHistory"/>
                                        </div>
                                    </div>
                                </div>
                            </div>--}}
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end row-->

@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js') }}"></script>
<script>
    $( function() {
        $('#sample_receive_date').datepicker();
        $('#invoice_date').datepicker({
        format: "{!! $companyDateFormate??'dd-mm-yyyy' !!}",
        autoclose: true,
        //startDate: financialYearDates.fromDate,//optional
        //endDate: financialYearDates.toDate//optional
        });
    });
    $(document).ready(function(){
        fetch_cart();
        $('.round_off_show').hide();
        var total_billing = $('#total_billing').val();
        $('#round_off').change(function() {
            if ($(this).is(':checked')) {
                $(this).val(1);
                $('.round_off_show').show();
                var roundOF =  Math.round(total_billing)
                var differenceAmount  = roundOF - total_billing;
                $('#final_total_billing_amount').val(roundOF);
                $('#round_off_amount').val(parseFloat(differenceAmount).toFixed(2));
            } else {
                var roundOF = 0;
                $(this).val(0);
                $('.round_off_show').hide();
                $('#round_off_amount').val(roundOF);
            }
        });
    });

    function fetch_cart(){
      $.ajax({
        url:"{!! route('ipd-sale-order-product-cart',['id'=>$id,'batch_id'=>$batch_id]) !!}?page=billing",
        success:function(data){
            $('.cart_products').html('');
            $('.cart_products').html(data);
        }
      })
    }

    $(document).on('click','.submit', function(e) {
        e.preventDefault();
        $('.error_payment_mode_id').hide();
        $('.error_payment_term_id').hide();
        $('.error_due_balance_amount').hide();
        $('.error_due_balance_amount_negative').hide();
        var error = 0;

        if (error == 0) {
            
            $('#billing_form').submit();
        }
    });

  

   

   




   

   

  
   

    
</script>
@endsection