<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Invoice No.</th>
                <th>Date</th>
                <th>Patient Name</th>
                <th>Voucher Type</th>
                <th class="thbutton">Status</th>
                <th class="thbutton">Bill</th>
                <th class="thbutton">View</th>
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td>
                            <a href="{!! route('ipd-billings.show', $list->getSaleInvoice->id) !!}">
                                <b>{{$list->getSaleInvoice->main_invoice_no}}</b>
                            </a>
                            <br>
                            <a href="{!! route('ipd-billing-report-logs', $list->getSaleInvoice->id) !!}">
                                Batch No: {{$list->invoice_batch_no ?? '' }}
                            </a>
                        </td>
                        <td>
                            {!! nl2br(e(formatedDateTime($list->getSaleInvoice->invoice_date))) !!}
                            <br>
                            {{$list->getSaleInvoice->getDoctor->account_title->name ?? ''}}
                            {{$list->getSaleInvoice->getDoctor->name ?? ''}}
                        </td>
                        <td>
                            {{$list->getSaleInvoice->getPatient->account_title->name ?? ''}}
                            {{$list->getSaleInvoice->getPatient->name ?? ''}}<br>
                            {{$list->getSaleInvoice->getPatient->account_contact->gender->name ?? ''}}
                            {{ isset($list->getSaleInvoice->getPatient->account_contact->date_of_birth) &&
                                isset($list->getSaleInvoice->getPatient->account_contact->gender) ? ', ' : '' }}
                                {{ isset($list->getSaleInvoice->getPatient->account_contact->date_of_birth) ? age($list->getSaleInvoice->getPatient->account_contact->date_of_birth) . ' years' : '' }}
                        </td>
                        <td>{!! $list->voucherType->name??'' !!}</td>

                        <td class="text-center">
                            <span class="badge bg-{!! $list->batch_status=='NEWORDER'?'warning':'success' !!}">{!! $list->batch_status??''  !!}</span>
                            
                        </td>
                        <td class="text-center">
                            <a class="btn btn-success" href="{!! route('ipd-sale-orders.invoice', ['id' => $list->getSaleInvoice->id, 'batch_id' => $list->id]) !!}">
                                <i class="bi bi-printer text-white"></i>
                            </a>
                        </td>
                        <td class="text-center">
                            <div class="btn-group" style="width: 100%">
                                <a class="btn btn-md btn-info" href="{!! route('ipd-sale-orders.view', ['id' => $list->getSaleInvoice->id, 'batch_id' => $list->id]) !!}" title="View Orders" style="width: 100%;">
                                    <i class="bi bi-eye text-white"></i> View Order
                                </a>
                            </div>
                        </td>
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="18">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="mt-2 row">
    <div class="col-lg-10 col-md-10 col-10 float-start">
    {!! $data->onEachSide(0)->render('sale.ipd-sale-orders.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
    </div>
</nav>
</div>
