<div class="table-responsive">
	<table id="example" class="table table-bordered align-middle" style="width:100%">
	    <thead class="table-light">
		    <tr>
		        <th class="thbutton">Sl No</th>
                <th>Tube Name</th>
                <th>Code</th>
                <th>Color</th>
                <th>Anticoagulant</th>
                <th>Detail</th>
                <th class="thbutton">Status</th>
                @if(in_array('collection-tube-edit', $authRolePermissions))
                    <th class="thbutton">Edit</th>
                @endif
                @if(in_array('collection-tube-delete', $authRolePermissions))
                    <th class="thbutton">Delete</th>
                @endif
		    </tr>
	    </thead>
	    <tbody>
	    	@php $i=1;@endphp
            @if(count($data)>0)
		    	@foreach ($data as $key => $sample_tube)
				    <tr>
				        <td class="text-center">{{$data->firstItem() + $key}}</td>
				        <td>{{ $sample_tube->tube_name }}</td>
				        <td>{{ $sample_tube->code }}</td>
                        <td style="background: {{ $sample_tube->color_code }}; color: white; text-align: center;">{{ $sample_tube->color_code }}<br>{{ $sample_tube->color_name }}</td>
                        <td style="white-space: break-spaces;">{{ $sample_tube->anticoagulant }}</td>
                        <td style="white-space: break-spaces;">{{ $sample_tube->details }}</td>
                        <td class="text-center">
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('sample-collection-tubes.changestatus')}}" data-id="{{$sample_tube->id}}" data-status="{{$sample_tube->status=='0' ? '1' : '0'}}" {{ $sample_tube->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('collection-tube-edit', $authRolePermissions))
                        <td class="text-center">
                            <button data-id="{{ $sample_tube->id }}" class="btn btn-outline-secondary edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square"></i>
                            </button>
                        </td>
                        @endif
                        @if(in_array('collection-tube-delete', $authRolePermissions))
                        <td class="text-center">
                            <a data-url="{{route('sample-collection-tubes.destroy')}}" data-id="{{$sample_tube->id}}" class="btn btn-danger deleteDataCustom" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
				    </tr>
			    @endforeach
			@else
                <tr>
                    <td colspan="11">No Data Found</td>
                </tr>
            @endif
	    </tbody>
	</table>
</div>
<nav class="row align-items-center mt-3">
    <div class="col-md-10">
        {!! $data->onEachSide(0)->render('sample-collection-tubes.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
    </div>
</nav>
</div>
