<form class="row g-3 auto-width" method="post" action="{{ route('signatures.update', $data->id )}}" enctype="multipart/form-data">
    @csrf
    @method('put')
    <div class="col-12">
        <label for="name" class="form-label">Name
            <span class="text-danger"><b>*</b></span>
        </label>
        <input type="text" value="{{ $data->name }}" class="form-control" name="name" aria-describedby="inputGroupPrepend" placeholder="Name">
        <span class="text-danger error_signature_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-12">
        <label for="description" class="form-label">Signature Upload</label>
        <input class="form-control" type="file" name="signature">
    </div>
    <div class="col-12">
        @if($data->signature != '')
            <img src="{!! getTempUrl($data->signature) !!}" height="auto" 
            style="cursor: pointer;max-height: 85px;height: 85px;">
        @else
            <img src="{!! asset('admin/images/signature.png') !!}" width="100%" height="auto" 
            style="cursor: pointer;max-height: 85px;height: 85px;">
        @endif
    </div>
    <div class="col-6">
        <label for="name" class="form-label">Max Height
            <span class="text-danger"><b>*</b></span>
        </label>
        <input type="number" class="form-control" name="max_height" aria-describedby="inputGroupPrepend" placeholder="200" value="{{ $data->max_height ?? '' }}">
        <span class="text-danger error_max_height" style="display:none;">This field is required.</span>
    </div>
    <div class="col-6">
        <label for="name" class="form-label">Max Width
            <span class="text-danger"><b>*</b></span>
        </label>
        <input type="number" class="form-control" name="max_width" aria-describedby="inputGroupPrepend" placeholder="200" value="{{ $data->max_width ?? '' }}">
        <span class="text-danger error_max_width" style="display:none;">This field is required.</span>
    </div>  
    <div class="col-12">
        <label for="signature_for" class="form-label">Signature for
            <span class="text-danger"><b>*</b></span>
        </label>
        <select class="form-control" name="signature_for">
            <option {{ ($data->signature_for == 'Doctor') ? 'selected' : '' }} value="Doctor">Doctor</option>
            <option {{ ($data->signature_for == 'Technician') ? 'selected' : '' }} value="Technician">Technician</option>
        </select>
    </div>
</form>