@extends('layouts.app')
@section('title','SMS Template')
@section('pages')


<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
  <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Settings</div>
  <div class="ps-3">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb mb-0 p-0">

        <li class="breadcrumb-item active" aria-current="page">Edit SMS Template</li>
      </ol>
    </nav>
  </div>
  <div class="ms-auto">
    <div class="btn-group">
        <a href="{{route('smstemplate.index')}}" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
    </div>
  </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width" action="{{route('smstemplate.update', $SmsTemplate->id)}}/" class="ajaxformfileupload" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            @csrf
            @method('PUT')
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body g-3 row">
                  <h5 class="mb-0">SMS API</h5>
                  <hr class="mb-0">
                  <div class="col-md-6">
                    <input type="hidden" name="id" value="@if(isset($SmsTemplate->id) && $SmsTemplate->id!=''){{$SmsTemplate->id}}@endif">
                    <label for="name" class="form-label">Template Used For <span class="text-danger"><b>*</b></span></label>
                    <input type="text" class="form-control" name="template_used_for" id="template_used_for" placeholder="Template Used For" value="@if(isset($SmsTemplate->template_use_for) && $SmsTemplate->template_use_for!=''){{$SmsTemplate->template_use_for}}@endif" required="">
                    @if ($errors->has('template_used_for'))
                    <span class="text-danger">{{ $errors->first('template_used_for') }}</span>
                    @endif
                  </div>
                  <div class="col-md-6">
                    <label for="validationTextarea" class="form-label">Principal Entiry ID <span class="text-danger"><b>*</b></span></label>
                    <input type="text" class="form-control" name="principal_entity_id" aria-label="file example" value="{{$smssetting->principal_entity_id??''}}">
                    <div class="invalid-feedback">Example invalid Principal Entiry ID</div>
                  </div>
                  <div class="col-md-6">
                    <label for="name" class="form-label">Template ID <span class="text-danger"><b>*</b></span></label>
                    <input type="text" class="form-control" value="@if(isset($SmsTemplate->template_id) && $SmsTemplate->template_id!=''){{$SmsTemplate->template_id}}@endif" name="template_id" id="template_id" placeholder="Template ID" required="">
                    @if ($errors->has('template_id'))
                    <span class="text-danger">{{ $errors->first('template_id') }}</span>
                    @endif
                  </div>
                  <div class="col-md-6">
                    <label for="name" class="form-label">Sendr ID <span class="text-danger"><b>*</b></span></label>
                    <input type="text" class="form-control" name="sender_id" value="@if(isset($SmsTemplate->sender_id) && $SmsTemplate->sender_id!=''){{$SmsTemplate->sender_id}}@endif" id="template_id" placeholder="Sendr ID" required="">
                    @if ($errors->has('sender_id'))
                    <span class="text-danger">{{ $errors->first('sender_id') }}</span>
                    @endif
                  </div>
                  <div class="col-12" align="center">
                    <div class="d-grid gap-2 with-50">
                      <button class="btn btn-primary"  type="submit"><i class="bx bx-save"></i> Update SMS Template</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body g-3 row">
                  <h5 class="mb-0">Additional</h5>
                  <hr class="mb-0">
                  <div class="col-md-6">
                    <label for="name" class="form-label">SMS Title</label>
                    <textarea type="text" class="form-control" name="sms_title" placeholder="SMS title" required="">
                    @if(isset($SmsTemplate->sms_title) && $SmsTemplate->sms_title!=''){{$SmsTemplate->sms_title}}@endif
                    </textarea>
                    @if ($errors->has('sms_title'))
                    <span class="text-danger">{{ $errors->first('sms_title') }}</span>
                    @endif
                  </div>
                  <div class="col-md-6">
                    <label for="name" class="form-label">SMS Body</label>
                    <textarea type="text" class="form-control" name="sms_body" placeholder="SMS body" required="">
                    @if(isset($SmsTemplate->sms_body) && $SmsTemplate->sms_body!=''){{$SmsTemplate->sms_body}}@endif
                    </textarea>
                    @if ($errors->has('sms_body'))
                    <span class="text-danger">{{ $errors->first('sms_body') }}</span>
                    @endif
                  </div>
                  <div class="col-md-12">
                    <label for="name" class="form-label">Template Format <span class="text-danger"><b>*</b></span></label>
                    <textarea type="date" class="form-control" name="template_format" placeholder="Template Format" required="">@if(isset($SmsTemplate->template_format) && $SmsTemplate->template_format!=''){{$SmsTemplate->template_format}}@endif</textarea>
                    @if ($errors->has('template_format'))
                    <span class="text-danger">{{ $errors->first('template_format') }}</span>
                    @endif
                  </div>
                  <div class="col-md-12">
                    <label for="name" class="form-label">SMS Signature</label>
                    <textarea type="date" class="form-control" name="sms_signature" placeholder="SMS Signature" required="">@if(isset($SmsTemplate->sms_signature) && $SmsTemplate->sms_signature!=''){{$SmsTemplate->sms_signature}}@endif</textarea>
                    @if ($errors->has('sms_signature'))
                    <span class="text-danger">{{ $errors->first('sms_signature') }}</span>
                    @endif
                  </div>


                </div>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>

  </div>
</div>
<!--end row-->
@endsection
