@extends('layouts.app')
@section('title','SMS API')
@section('pages')


<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Settings</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">SMS API</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('smstemplate.index')}}" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class="shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width ajaxformfileupload" action="{{ route('smsapitemplate.updatesmsapi') }}" method="post" enctype='multipart/form-data'>
                        <!-- For validation comment on -->
                        <!-- <form class="row g-3 was-validated"> -->
                        <div class="col-md-6 col-sm-12">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">SMS API</h5>
                                    <hr class="mb-0">
                                    <input type="hidden" name="id" value="@if(isset($SmsApi->id) && $SmsApi->id!=''){{$SmsApi->id}}@endif">
                                    <div class="col-md-6">
                                        <label for="validationCustom01" class="form-label">User Name <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="validationCustom01" name="user_name" value="@if(isset($SmsApi->user_name) && $SmsApi->user_name!=''){{$SmsApi->user_name}}@endif" required>
                                        @if ($errors->has('user_name'))
                                        <span class="text-danger">{{ $errors->first('user_name') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustomUsername" class="form-label">Password <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="validationCustomUsername" name="password" aria-describedby="inputGroupPrepend" value="@if(isset($SmsApi->password) && $SmsApi->password!=''){{$SmsApi->password}}@endif" required>
                                        @if ($errors->has('password'))
                                        <span class="text-danger">{{ $errors->first('password') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationTextarea" class="form-label">Principal Entity ID <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" name="principal_entity_id" aria-label="file example" value="@if(isset($SmsApi->principal_entity_id) && $SmsApi->principal_entity_id!=''){{$SmsApi->principal_entity_id}}@endif">
                                        <div class="invalid-feedback">Example invalid Principal Entity ID</div>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">SMS Signature </label>
                                        <input type="text" class="form-control" placeholder="" name="sms_signature" value="@if(isset($SmsApi->sms_signature) && $SmsApi->sms_signature!=''){{$SmsApi->sms_signature}}@endif" />
                                        @if ($errors->has('sms_signature'))
                                        <span class="text-danger">{{ $errors->first('sms_signature') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-50">
                                            <button class="btn btn-primary" type="submit">Save SMS API <i class="bx bx-save"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Additional</h5>
                                    <hr class="mb-0">
                                    <div class="col-md-6">
                                        <label for="validationTextarea" class="form-label">SMS Notify Mobile</label>
                                        <input type="text" class="form-control" placeholder="" name="sms_notify_mobile" value="@if(isset($SmsApi->sms_notify_mobile) && $SmsApi->sms_notify_mobile!=''){{$SmsApi->sms_notify_mobile}}@endif" />
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationTextarea" class="form-label">SMS Notify Email</label>
                                        <input type="text" class="form-control" placeholder="" name="sms_notify_email" value="@if(isset($SmsApi->sms_notify_email) && $SmsApi->sms_notify_email!=''){{$SmsApi->sms_notify_email}}@endif" />
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationTextarea" class="form-label">SMS Notify URL</label>
                                        <input type="text" class="form-control" placeholder="" name="sms_notify_url" value="@if(isset($SmsApi->sms_notify_url) && $SmsApi->sms_notify_url!=''){{$SmsApi->sms_notify_url}}@endif" />
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationTextarea" class="form-label">Enable Sms Api</label>
                                        <select class="form-control" name="enable_sms_api" placeholder="SMS Notify Api" required="">
                                            <option value="">Select</option>
                                            <option @if(isset($SmsApi->enable_sms_api) && $SmsApi->enable_sms_api=='yes') selected @endif value="yes">Yes</option>
                                            <option @if(isset($SmsApi->enable_sms_api) && $SmsApi->enable_sms_api=='no') selected @endif value="no">No</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
<!--end row-->
@endsection
