@extends('layouts.app')
@section('title','Software Branding')
@section('pages')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<style type="text/css">
    .add_btn {
        height: 30px; width: 30px; border-radius: 100%; padding: 0
    }
    .intl-tel-input {
        width: 100%;
    }
    .breadcrumb-title {
      border-right: none;
    }
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
  <link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">

<!--breadcrumb-->
<div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
  <div class="breadcrumb-title col-md-6"> Software Branding
  </div>
  <div class="col-md-6">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb justify-content-md-end mb-0">
        <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="49" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
        <li class="breadcrumb-item" aria-current="page">Settings</li>
        <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Software Branding</li>
      </ol>
    </nav>
  </div>
</div>
<!--end breadcrumb-->

<div class="card style_table shadow-none radius-5 min-height">
  <div class="card-header py-3">
    @include('layouts.partials.nav-menu')
    <div class="row gx-2">
      <div class="col-lg-12 col-md-12">
        <div class="ms-auto float-md-end">
          <div class="btn-group">
              <a href="{{route('modules.index')}}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width" action="{{ route('software-branding.update', $branding->id)}}" method="post" id="branding-form" enctype='multipart/form-data'>
                        @csrf
                        @method('patch')
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Software Branding Details</h5>
                                    <hr class="mb-0">
                                    <div class="col-md-6">
                                        <label for="company_name" class="form-label">Company name <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="company_name" name="company_name" aria-describedby="inputGroupPrepend" required value="{{$branding->company_name}}">
                                        <span class="text-danger error_company_name" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="website" class="form-label">Website <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="website" name="website" aria-describedby="inputGroupPrepend" required value="{{$branding->website}}">
                                        <span class="text-danger error_website" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="email" class="form-label"> Email Id <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="email" name="email" aria-describedby="inputGroupPrepend"  value="{{$branding->email}}">
                                        <span class="text-danger error_email" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="sales_email" class="form-label">Sales email <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="sales_email" name="sales_email" aria-describedby="inputGroupPrepend" required value="{{$branding->sales_email}}">
                                        <span class="text-danger error_sales_email" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="support_email" class="form-label">Support email <span class="text-danger"><b>*</b></span></label>
                                        <input type="text" class="form-control" id="support_email" name="support_email" aria-describedby="inputGroupPrepend" required value="{{$branding->support_email}}">
                                        <span class="text-danger error_support_email" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6 sales_number_col">
                                        <label for="sales_number" class="form-label">Sales number <span class="text-danger"><b>*</b></span></label>
                                        <input type="tel" class="form-control" placeholder="" id="sales_number" required value="{{$branding->sales_number}}"/>
                                        <input type="hidden" name="sales_number" value="{{$branding->sales_number}}">
                                        <span class="text-danger error_sales_number" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6 support_number_col">
                                        <label for="support_number" class="form-label">Support number <span class="text-danger"><b>*</b></span></label>
                                        <input type="tel" class="form-control" placeholder="" id="support_number" required value="{{$branding->support_number}}"/>
                                        <input type="hidden" name="support_number" value="{{$branding->support_number}}">
                                        <span class="text-danger error_support_number" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6 whatsapp_number_col">
                                        <label for="whatsapp_number" class="form-label">Whatsapp number <span class="text-danger"><b>*</b></span></label>
                                        <input type="tel" class="form-control" placeholder="" id="whatsapp_number" required value="{{$branding->whatsapp_number}}"/>
                                        <input type="hidden" name="whatsapp_number" value="{{$branding->whatsapp_number}}">
                                        <span class="text-danger error_whatsapp_number" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="facebook" class="form-label">Facebook</label>
                                        <input type="text" class="form-control" id="facebook" name="facebook" aria-describedby="inputGroupPrepend" value="{{$branding->facebook}}">
                                        <span class="text-danger error_facebook" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="twitter" class="form-label">Twitter</label>
                                        <input type="text" class="form-control" id="twitter" name="twitter" aria-describedby="inputGroupPrepend" value="{{$branding->twitter}}">
                                        <span class="text-danger error_twitter" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="linkedin" class="form-label">Linkedin</label>
                                        <input type="text" class="form-control" id="linkedin" name="linkedin" aria-describedby="inputGroupPrepend" value="{{$branding->linkedin}}">
                                        <span class="text-danger error_linkedin" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="youtube" class="form-label">Youtube</label>
                                        <input type="text" class="form-control" id="youtube" name="youtube" aria-describedby="inputGroupPrepend" value="{{$branding->youtube}}">
                                        <span class="text-danger error_youtube" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="instagram" class="form-label">Instagram</label>
                                        <input type="text" class="form-control" id="instagram" name="instagram" aria-describedby="inputGroupPrepend" value="{{$branding->instagram}}">
                                        <span class="text-danger error_instagram" style="display:none;">This field is required.</span>
                                    </div>
                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                            @if(auth()->user()->can('software-branding-edit'))
                                                <button class="btn btn-primary save_button"  type="button"><i class="bx bx-save"></i> Update Branding Details</button>
                                            @endif
                                      </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Additional Information</h5>
                                    <hr class="mb-0">
                                    <div class="col-md-6">
                                        <label for="sale_info" class="form-label">Company Logo</label>
                                        <input type="file" class="form-control" id="company_logo" name="company_logo" value="{{$branding->website}}">
                                        <span class="text-danger error_company_logo" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-6">
                                        @if($branding->company_logo != '' && file_exists('uploads/software-branding/' . $branding->company_logo ))
                                            <img class="round" src="{!! asset('uploads/software-branding/' . $branding->company_logo) !!}" alt="avatar" height="65" width="65"></span>
                                        @else
                                            <img class="round" src="{!! asset('admin/images/avtaar.png') !!}" alt="avatar" height="65" width="65"></span>
                                        @endif
                                    </div>
                                    <div class="col-md-12">
                                        <label for="sale_info" class="form-label">Sale info</label>
                                        <textarea class="form-textarea" id="sale_info" name="sale_info">{!! $branding->sale_info !!}</textarea>
                                        <span class="text-danger error_sale_info" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="support_info" class="form-label">Support info</label>
                                        <textarea class="form-textarea" id="support_info" name="support_info">{!! $branding->support_info !!}</textarea>
                                        <span class="text-danger error_support_info" style="display:none;">This field is required.</span>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="social_info" class="form-label">Social info</label>
                                        <textarea class="form-textarea" id="social_info" name="social_info">{!! $branding->social_info !!}</textarea>
                                        <span class="text-danger error_social_info" style="display:none;">This field is required.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                  </form>
              </div>
          </div>
      </div>
  </div>
</div>
<!--end row-->
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
<script type="text/javascript">
    var telInput = $('#sales_number , #support_number, #whatsapp_number');
    telInput.intlTelInput({
        utilsScript: 'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js', // Update the URL to the correct one
        initialCountry: 'us', // Set the new country code
        separateDialCode: true
    });

    // var telInput1 = $('#whatsapp_number , #support_number');
    // telInput.intlTelInput({
    //     utilsScript: 'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js', // Update the URL to the correct one
    //     initialCountry: 'us', // Set the new country code
    //     separateDialCode: true
    // });
    $(document).on('click','.save_button', function(e) {
        e.preventDefault();
        if ($('#sales_number').val().trim() != '') {
            var dailcode_title = $('.sales_number_col .selected-flag').attr('title');
            var dailcode_array = dailcode_title.split("+");
            $('input[name="sales_number"]').val("+" + dailcode_array[1] + $('#sales_number').val());
        }

        if ($('#support_number').val().trim() != '') {
            var dailcode_title = $('.support_number_col .selected-flag').attr('title');
            var dailcode_array = dailcode_title.split("+");
            $('input[name="support_number"]').val("+" + dailcode_array[1] + $('#support_number').val());
        }

        if ($('#whatsapp_number').val().trim() != '') {
            var dailcode_title = $('.whatsapp_number_col .selected-flag').attr('title');
            var dailcode_array = dailcode_title.split("+");
            $('input[name="whatsapp_number"]').val("+" + dailcode_array[1] + $('#whatsapp_number').val());
        }

        $('.error_sales_number').hide();
        $('.error_support_number').hide();
        $('.error_whatsapp_number').hide();
        var error = 0;

        if ($('input[name="sales_number"]').val().trim() == '') {
          $('.error_sales_number').show();
          error = 1;
        }

        if ($('input[name="support_number"]').val().trim() == '') {
          $('.error_support_number').show();
          error = 1;
        }

        if ($('input[name="whatsapp_number"]').val().trim() == '') {
          $('.error_whatsapp_number').show();
          error = 1;
        }

        if (error == 0) {
          $('#branding-form').submit();
        }
        error = 1;
    })
</script>
@endsection
