<div class="table-responsive">
    <table id="tables" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Date Time</th>
                <th>Voucher Number</th>
                <th>Product Name</th>
                <th>Stock Type</th>
                <th class="text-end">PACK QTY IN</th>
                <th class="text-end">LOOSE QTY IN</th>
                <th class="text-end">PACK QTY OUT</th>
                <th class="text-end">LOOSE QTY OUT</th>
                <th class="text-end">Basic AMT</th>
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td>{{ formatedDate($list->entry_date) }}<br>{{ formatedTime($list->entry_date) }}</td>
                        <td>
                            @if($list->voucher_type=='SALES' || $list->voucher_type=='IPD_INVOICE')
                                {!! $list->voucherSaleType->voucher_type_invoice_no??'' !!}
                            @elseif($list->voucher_type=='PURCHASE')
                                {!! $list->voucherPurchaseType->main_invoice_no??'' !!}
                            @elseif($list->voucher_type=='SALE_RETURN')
                                {!! $list->voucherReturnType->main_invoice_no??'' !!}
                            @elseif($list->voucher_type=='STOCK_IN')
                                {!! $list->voucherStockIn->main_invoice_no??'' !!}
                            @elseif($list->voucher_type=='STOCK_OUT')
                                {!!   $list->voucherStockOut->voucher_type_invoice_no??'' !!}
                            @endif
                        </td>
                        <td>{{ strtoupper($list->getProduct->name??'') }}<br>
                            <div style="color:#aaa">By: {!! $list->getCreatedBy->prepared_by??'' !!}</div>
                        </td>
                        <td>
                            @if(isset($list->getMovementType))
                                {{$list->getMovementType->name??'' }}
                            @else
                                {!! $list->stock_type??'' !!}
                            @endif
                        </td>
                        <td class="text-end">{{ convertDecimelPoint($list->pack_qty_in + $list->free_qty) ?? ''}}</td>
                        <td class="text-end">{{ $list->loose_qty_in  }} </td>
                        <td class="text-end">{{ $list->pack_qty_out }}</td>
                        <td class="text-end">{{ $list->loose_qty_out }}</td>
                        <td class="text-end">{{ $list->taxable_unit_price }}</td>
                       
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="9">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>

<nav class="row align-items-center mt-2">
    <div class="col-md-10">
        {!! $data->onEachSide(0)->render('stocks.inventory-and-stocks.pagination') !!}
    </div>

    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
            <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
            <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
                <option value="10">Show: 10</option>
                <option value="30">Show: 30</option>
                <option value="50">Show: 50</option>
            </select>
    </div>
</nav>
</div>

