<div class="table-responsive">
    <table id="tables" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">
                    Serial No
                    <!-- <input type="checkbox" name="select_all_table" class="select-all-table" id="select-all-table" autocomplete="off"> -->
                </th>
                <th>Product Name</th>
                <th>Batch No.</th>
                <th>UOM</th>
                <th>Expiry Date</th>
                <th class="thbutton text-end">Opening Stock</th>
                <th class="thbutton text-end">Basic AMT</th>
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">
                        {{$data->firstItem() + $key}}   
                            <input hidden type="checkbox" class="select_all_product_ids" value="{!! $list->product_price_id !!}" autocomplete="off" checked>
                        </td>
                        <td>{!! $list->name  !!}</td>
                        <td>{!! $list->batch??'' !!}</td>
                        <td>{!! $list->getProductPrimaryUnit->name??'' !!}</td>
                        <td>{!! $list->exp_date?formatedDate($list->exp_date):'' !!}</td>
                        <td class="text-end">{!! $list->opening_stock_pack??'' !!}</td>
                        <td class="text-end">{{ isset($list->mrp) ? convertDecimelPoint($list->mrp):'' }}</td>
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="9">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>

<nav class="row align-items-center mt-2">
    <div class="col-md-10">
        {!! $data->onEachSide(0)->render('stocks.opening-stock.pagination') !!}
    </div>

    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
            <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
            <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
                <option value="50" {!! $sort_by==50?"selected":'' !!}>Show: 50</option>
                <option value="100" {!! $sort_by==100?"selected":'' !!}>Show: 100</option>
                <option value="150" {!! $sort_by==150?"selected":'' !!}>Show: 150</option>
                <option value="200" {!! $sort_by==200?"selected":'' !!}>Show: 200</option>
                <option value="250" {!! $sort_by==250?"selected":'' !!}>Show: 250</option>
            </select>
    </div>
</nav>
</div>

<script>
    $('.select-all-table').click(function(event) {   
        if(this.checked) {
            $('.select_all_product_ids').each(function() {
                this.checked = true;                        
            });
        } else {
            $('.select_all_product_ids').each(function() {
                this.checked = false;                       
            });
        }
    }); 
</script>

