<div class="table-responsive">
    <table id="tables" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Serial No</th>
                <th>Date Time</th>
                <th>Voucher Number</th>
                <th class="text-end">Basic AMT</th>
                <th class="thbutton">Bill</th>
                <th class="thbutton">Edit</th>
                <th class="thbutton">Delete</th>
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td>{{ formatedDateTime($list->invoice_date) }}</td>
                        <td>{!! $list->main_invoice_no??'' !!}</td>
                        <td class="text-end">{{ isset($list->getStockOutInvoiceBasicAmt) ? convertDecimelPoint($list->getStockOutInvoiceBasicAmt->basic_amount):'' }}</td>
                        <td class="text-center">
                            <a class="btn btn-info" href="{!! route('stock-out.invoice', $list->id) !!}">
                            <i class="bi bi-printer text-white"></i>
                            </a>
                        </td>
                        <td class="text-center">
                            <a href="{!! route('stock-out.edit',$list->id) !!}" class="btn btn-warning " title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </a>
                        </td>
                        <td class="text-center">
                            <a data-url="{{route('stock-out.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="9">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>

<nav class="row align-items-center mt-2">
    <div class="col-md-10">
        {!! $data->onEachSide(0)->render('stocks.stock-out.pagination') !!}
    </div>

    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
            <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
            <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
                <option value="10">Show: 10</option>
                <option value="30">Show: 30</option>
                <option value="50">Show: 50</option>
            </select>
    </div>
</nav>
</div>

