@extends('layouts.app')
@section('title','Storage Settings')
@section('pages')
<style type="text/css">
    .add_btn {
        height: 30px; width: 30px; border-radius: 100%; padding: 0
    }
    .intl-tel-input {
        width: 100%;
    }
    input::-webkit-outer-spin-button,
    input::-webkit-inner-spin-button {
    -webkit-appearance: none;
    margin: 0;
}
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
  <link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Storage Settings</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Add New Storage Settings</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('storage-settings.index')}}" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width" action="{{ route('storage-settings.store')}}" method="post" enctype='multipart/form-data'>
                        <!-- For validation comment on -->
                        <!-- <form class="row g-3 was-validated"> -->
                        @csrf
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Create Storage Setting</h5>
                                    <hr class="mb-0">

                                    <div class="col-md-6">
                                        <div>
                                            <label for="bucket_name" class="form-label">Storage Provider <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select class="single-select" name="storage_type">
                                                <option value="local">Local</option>
                                                <option value="s3_bucket">S3 Bucket</option>
                                                <option value="wasabi">Wasabi</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="bucket_name" class="form-label">Bucket name <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" value="{{ old('bucket_name') }}" name="bucket_name">
                                        </div>
                                        @if ($errors->has('bucket_name'))
                                            <span class="text-danger">{{ $errors->first('bucket_name') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="access_key" class="form-label">Access key</label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" value="{{ old('access_key') }}" name="access_key">
                                        </div>
                                        @if ($errors->has('access_key'))
                                            <span class="text-danger">{{ $errors->first('access_key') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="secret_key" class="form-label">Secret key</label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" value="{{ old('secret_key') }}" name="secret_key">
                                        </div>
                                        @if ($errors->has('secret_key'))
                                            <span class="text-danger">{{ $errors->first('secret_key') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="region" class="form-label">Region <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" value="{{ old('region') }}" name="region">
                                        </div>
                                        @if ($errors->has('region'))
                                            <span class="text-danger">{{ $errors->first('region') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="acl" class="form-label">ACL <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select name="acl" id="acl" class="form-control" required>
                                                <option value="public-read">Public read</option>
                                                <option value="private">Private</option>
                                            </select>
                                        </div>
                                        @if ($errors->has('acl'))
                                            <span class="text-danger">{{ $errors->first('acl') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="storage_limit" class="form-label">Storage limit (GB) <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" value="{{ old('storage_limit') }}" name="storage_limit">
                                        </div>
                                        @if ($errors->has('storage_limit'))
                                            <span class="text-danger">{{ $errors->first('storage_limit') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="main_folder" class="form-label">Endpoint/Main folder <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" value="{{ old('main_folder') }}" name="main_folder">
                                        </div>
                                        @if ($errors->has('main_folder'))
                                            <span class="text-danger">{{ $errors->first('main_folder') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="enquiry_category_id" class="form-label">Only Upload Files <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <select class="multiple-select" multiple="multiple" name="storage_validation[]">
                                                @foreach (storageExtensions() as $extension)
                                                    <option value="{!! $extension !!}">{!! $extension !!}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @if ($errors->has('storage_validation'))
                                            <span class="text-danger">{{ $errors->first('storage_validation') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="enquiry_type_id" class="form-label">Max upload size ( In KB) <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="number" class="form-control" value="{{ old('storage_max_upload_size') }}" name="storage_max_upload_size">
                                        </div>
                                        @if ($errors->has('storage_max_upload_size'))
                                            <span class="text-danger">{{ $errors->first('storage_max_upload_size') }}</span>
                                        @endif
                                    </div>
                                </div>
                                <div class="card-body g-3 row additional_fields">
                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                          <button class="btn btn-primary" type="submit"><i class="bx bx-save"></i> Add Storage Setting</button>
                                      </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                  </div>
              </div>
          </div>
      </div>
  </div>
  <!--end row-->
@endsection

