@extends('layouts.app')
@section('title','Enquiries')
@section('pages')


<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Enquiries</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                
                <li class="breadcrumb-item active" aria-current="page"> Enquiry Details</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->

<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class="shadow-none radius-5 min-height">
            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body g-3">
                            <div class="table-responsive">
                                <h5 class="mb-0">Enquiry Basic Details</h5>
                                <hr class="mb-2">
                                <table class="table table-bordered align-middle">
                                      <tr>
                                          <td>Enquiry Date</td>
                                          <td>{{ date('d M Y', strtotime($enquiry->enquiry_date)) }}</td>
                                      </tr>
                                      <tr>
                                          <td>Enquiry Customer</td>
                                          <td>{{$enquiry->name}}</td>
                                      </tr>
                                      <tr>
                                          <td>Customer Address</td>
                                          <td>{{$enquiry->address}}</td>
                                      </tr>
                                      <tr>
                                          <td>Phone Number</td>
                                          <td>{{$enquiry->phone_no}}</td>
                                      </tr>
                                      <tr>
                                          <td>Organization</td>
                                          <td>{{$enquiry->organization}}</td>
                                      </tr>
                                      <tr>
                                          <td>Contact Person</td>
                                          <td>{{$enquiry->contact_person}}</td>
                                      </tr>
                                      <tr>
                                          <td>Whatsapp Number</td>
                                          <td>{{$enquiry->whatsapp_no}}</td>
                                      </tr>
                                      @foreach($extraField as $value)
                                        <tr>
                                            <td>{{$value->field}}</td>
                                            <td>{{$value->value}}</td>
                                        </tr>
                                      @endforeach
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-body g-3 row">
                                <div class="table-responsive">
                                    <h5 class="mb-0">Additional Details</h5>
                                    <hr class="mb-2">
                                    <table class="table table-bordered align-middle">
                                        <tr>
                                            <td>Alternative Number</td>
                                            <td>{{ $enquiry->alternative_no }}</td>
                                        </tr>
                                        <tr>
                                            <td>Email</td>
                                            <td>{{ $enquiry->email }}</td>
                                        </tr>
                                        <tr>
                                            <td>Enquiry Status</td>
                                            <td><span class="badge badge-pill" style="background: {!!$enquiry->bg_color!!}; color: {!!$enquiry->color!!}">{{ $enquiry->enquiry_status_name }}</span></td>
                                        </tr>
                                        <tr>
                                            <td>Enquiry Type</td>
                                            <td>{{ $enquiry->enquiry_type_name }}</td>
                                        </tr>
                                        <tr>
                                            <td>Enquiry Category</td>
                                            <td>{{ $enquiry->category_name }}</td>
                                        </tr>
                                        <tr>
                                            <td>Enquiry Source</td>
                                            <td>{{ $enquiry->enquiry_source_name }}</td>
                                        </tr>
                                        <tr>
                                            <td>Enquiry Quality</td>
                                            <td>{{ $enquiry->enquiry_quality_name }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--end row-->
@endsection