@extends('layouts.app')
@section('title','Students')
@section('pages')
<style type="text/css">
    .add_btn {
        height: 30px; width: 30px; border-radius: 100%; padding: 0
    }
    .intl-tel-input {
        width: 100%;
    }
</style>
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
  <link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">

<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Students</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">

                <li class="breadcrumb-item active" aria-current="page">Edit Student Temp</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="">
                    <form class="row g-3 auto-width ajaxformfileupload" action="{{ route('student-bulk-list-update', $TempData->id)}}" method="post" enctype='multipart/form-data'>
                        <!-- For validation comment on -->
                        <!-- <form class="row g-3 was-validated"> -->
                        @csrf
                        @method('patch')
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Student Details</h5>
                                    <hr class="mb-0">
                                    <div class="col-md-6">
                                        <div>
                                            <label for="name" class="form-label">Admission No  <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="admission_no" class="form-control" value="{!! $TempData->admission_no !!}">
                                        </div>
                                        @if ($errors->has('admission_no'))
                                            <span class="text-danger">{{ $errors->first('admission_no') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="student_name" class="form-label">Student Name  <span class="text-danger"><b>*</b></span></label>
                                        </div>
                                        <div class="input-group">
                                        <input type="text" name="student_name" class="form-control" value="{!! $TempData->student_name !!}">
                                        </div>
                                        @if ($errors->has('student_name'))
                                            <span class="text-danger">{{ $errors->first('student_name') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="gander" class="form-label">Gander </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="gander" value="{!! $TempData->gander !!}">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div>
                                            <label for="dob" class="form-label">Date of Birth </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="dob" id="dob" class="form-control" value="{!! $TempData->dob !!}">
                                        </div>
                                        @if ($errors->has('dob'))
                                            <span class="text-danger">{{ $errors->first('dob') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="caste" class="form-label">Caste </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="caste" class="form-control" value="{!! $TempData->caste !!}">
                                        </div>
                                        @if ($errors->has('caste'))
                                            <span class="text-danger">{{ $errors->first('caste') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="email" class="form-label">Email </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="email" class="form-control" value="{!! $TempData->email !!}">
                                        </div>
                                        @if ($errors->has('email'))
                                            <span class="text-danger">{{ $errors->first('email') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="mobile" class="form-label">Mobile </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="mobile" class="form-control" value="{!! $TempData->mobile !!}">
                                        </div>
                                        @if ($errors->has('mobile'))
                                            <span class="text-danger">{{ $errors->first('mobile') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="blood_group" class="form-label">Blood Group </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="blood_group" class="form-control" value="{!! $TempData->blood_group !!}">
                                        </div>
                                        @if ($errors->has('blood_group'))
                                            <span class="text-danger">{{ $errors->first('blood_group') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="house" class="form-label">House </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="house" class="form-control" value="{!! $TempData->house !!}">
                                        </div>
                                        @if ($errors->has('house'))
                                            <span class="text-danger">{{ $errors->first('house') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="address" class="form-label">Address </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="address" class="form-control" value="{!! $TempData->address !!}">
                                        </div>
                                        @if ($errors->has('address'))
                                            <span class="text-danger">{{ $errors->first('address') }}</span>
                                        @endif
                                    </div>
                                    
                                </div>
                                <div class="card-body g-3 row">
                                    <div class="col-12" align="center">
                                        <div class="d-grid gap-2 with-100">
                                          <button class="btn btn-primary" type="submit"><i class="bx bx-save"></i> Update Details</button>
                                      </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Additional Information</h5>
                                    <hr class="mb-0">
                                    <div class="col-md-6">
                                        <div>
                                            <label for="father_name" class="form-label">Father Name </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="father_name" class="form-control" value="{!! $TempData->father_name !!}">
                                        </div>
                                        @if ($errors->has('father_name'))
                                            <span class="text-danger">{{ $errors->first('father_name') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="mother_name" class="form-label">Mother Name </label>
                                        </div>
                                        <div class="input-group">
                                        <input type="text" value="{!! $TempData->mother_name !!}" name="mother_name" class="form-control">
                                        </div>
                                        @if ($errors->has('mother_name'))
                                            <span class="text-danger">{{ $errors->first('mother_name') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="gaurdian_name" class="form-label">Gaurdian Name </label>
                                        </div>
                                        <div class="input-group">
                                        <input type="text" value="{!! $TempData->gaurdian_name !!}" name="gaurdian_name" class="form-control">
                                        </div>
                                        @if ($errors->has('gaurdian_name'))
                                            <span class="text-danger">{{ $errors->first('gaurdian_name') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="date_of_adminssion" class="form-label">Admission Date </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="" value="{!! isset($TempData->date_of_adminssion) ? date('Y-m-d', strtotime($TempData->date_of_adminssion)) : '' !!}" name="date_of_adminssion" class="form-control" id="admission_date" >
                                        </div>
                                        @if ($errors->has('date_of_adminssion'))
                                            <span class="text-danger">{{ $errors->first('date_of_adminssion') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="academic_year" class="form-label">Academic Year </label>
                                        </div>
                                        <div class="input-group">
                                        <input type="text" value="{!! $TempData->academic_year !!}" name="academic_year" class="form-control">
                                        </div>
                                        @if ($errors->has('academic_year'))
                                            <span class="text-danger">{{ $errors->first('academic_year') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="class" class="form-label">Class </label>
                                        </div>
                                        <div class="input-group">
                                        <input type="text" value="{!! $TempData->class !!}" id="class" name="class" class="form-control" onkeyup='fetch_error("class","{!! route('check_error_student') !!}");'>
                                        </div>
                                        <span class="text-danger error_class" style="display:none;"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="section" class="form-label">Section </label>
                                        </div>
                                        <div class="input-group">
                                        <input type="text" value="{!! $TempData->section !!}" id="section" name="section" class="form-control" onkeyup='fetch_error("section","{!! route('check_error_student') !!}");'>
                                        </div>
                                        <span class="text-danger error_section" style="display:none;"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="language" class="form-label">Language </label>
                                        </div>
                                        <div class="input-group">
                                        <input type="text" value="{!! $TempData->language !!}" name="language" class="form-control">
                                        </div>
                                        @if ($errors->has('language'))
                                            <span class="text-danger">{{ $errors->first('language') }}</span>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            <label for="merital_status" class="form-label">Merital Status </label>
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="merital_status" class="form-control" value="{!! $TempData->merital_status !!}">
                                        </div>
                                        @if ($errors->has('merital_status'))
                                            <span class="text-danger">{{ $errors->first('merital_status') }}</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                  </form>
              </div>
          </div>
      </div>
  </div>
</div>
  <!--end row-->
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>

<script>
        fetch_error('section', "{!! route('check_error_student') !!}");
        fetch_error('class', "{!! route('check_error_student') !!}");
        
        function fetch_error(id, route) {
        var varname = id;
        var ids = $('#' + id).val();
        var str = varname + '=' + ids;
        $.ajax({
            url: route + '?' + str,
            success: function(data) {
                if (data.success == false) {
                    $('.error_' + id).css("display", "block")
                    $('.error_' + id).html(data.message);
                } else {
                    $('.error_' + id).css("display", "none")
                }

            }
        })
    }
     $( function() {
        
        $('#admission_date').datepicker();
        $('#dob').datepicker();
        $('#admission_date').datepicker().on('changeDate', function(ev) {
            $('#admission_date').datepicker('hide');
        });
        $('#dob').datepicker().on('changeDate', function(ev) {
            $('#dob').datepicker('hide');
        });

        
    });
</script>
@endsection
