 <div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Admission No</th>
                <th>Student Name</th>
                <th>Date of Birth</th>
                <th>Gender</th>
                <th>Category</th>
                <th>Phone No</th>
                @if(in_array('students-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('students-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td>{!! $list->unique_register_no !!}</td>
                        <td><a href="{{route('students.show',$list->id)}}"><strong>{{ucfirst($list->name)}}</strong></a></td>
                        <td>{!! $list->date_of_birth !!}</td>
                        <td>{!! $list->gender !!}</td>
                        <td>{!! $list->category !!}</td>
                        <td><a href="tel:{{$list->phone_no}}">{{$list->phone_no}}</a><br>
                            {{$list->email}}
                        </td>
                        @if(in_array('students-edit', $authRolePermissions))
                        <td class="text-center">
                            <a href="{{route('students.edit',$list->id)}}" class="btn btn-outline-secondary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                                <i class="bi bi-pencil-square"></i>
                            </a>
                        </td>
                        @endif
                        @if(in_array('students-delete', $authRolePermissions))
                        <td class="text-center">
                            <a data-url="{{route('students.destroy',$list->id)}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
            <tr>
                <td colspan="10">No Data Found</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="row align-items-center mt-3">
    <div class="col-md-6">
        {!! $data->onEachSide(0)->render('students.pagination') !!}
    </div>
    @if(in_array('students-create', $authRolePermissions))
    <div class="col-md-6" style="text-align: right;">
        <div class="btn-group mb-0">
            <a href="{!! route('students.export') !!}" class="btn btn-outline-primary"><i class="bi bi-download"></i> Export</a>
        </div>
        <div class="btn-group mb-0">
            <a href="{!! route('students.import') !!}" class="btn btn-outline-primary"><i class="bi bi-upload"></i> Import</a>
        </div>
    </div>
    @endif
</nav>
</div>
