@extends('layouts.app')
@section('title', 'Study Materials')
@section('pages')

<style type="text/css">
    .breadcrumb-title {
        border-right: none;
    }

    tr td {
        vertical-align: middle !important; 
    }
</style>


<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
<!-- breadcrumb -->
<div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
    <div class="breadcrumb-title col-md-6">Study Materials</div>
    <div class="col-md-6">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb justify-content-md-end mb-0">
                <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="93" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
                <li class="breadcrumb-item active" aria-current="page">Study Materials</li>
                <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Study Materials</li>
            </ol>
        </nav>
    </div>
</div>
<!-- end breadcrumb -->

<div class="card style_table shadow-none radius-5 min-height">
    <div class="card-header py-3">
        @include('layouts.partials.nav-menu')
        <div class="row gx-2">
            <div class="col-lg-5 col-md-5">
                <h6><b>{{$course->course_title??''}}</b> / {!! $materialType->name??'' !!}</h6>
            </div>

            <div class="col-lg-7 col-md-7">
                <div class="ms-auto float-md-end">
                    <div class="btn-group">
                         <button class="btn btn-primary" id="create_study_materials" type="button" data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus-circle"></i> Add Study Materials</button>
                    </div>
                    <div class="btn-group">
                    <a href="{{route('courses.show',$course_id)}}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="card-body" id="tables">
        @include('study-materials.table')
        <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
        <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
        <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
    </div>
</div>

@endsection
@section('js')
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
<script>
/***************** Global Delay Fucntion ***************/
     function delay(callback, ms) {
        var timer = 0;
        return function() {
            var context = this,
                args = arguments;
            clearTimeout(timer);
            timer = setTimeout(function() {
                callback.apply(context, args);
            }, ms || 0);
        };
    }


  function clear_icon(){
    $('#id_icon').html('');
    $('#post_title_icon').html('');
  }
  function fetch_data(page, sort_type, sort_by, query, account_type, accounting_groups){
    var search_type = $('[name="search_type"]').val();

    $.ajax({
      url:"?page="+page+"&sortby="+sort_by+"&sorttype="+sort_type+"&query="+query+"&accounting_groups="+accounting_groups+"&account_type="+account_type+"&search_type="+search_type,
      success:function(data){
        $('#tables').html('');
        $('#tables').html(data);
        $(document).ready(function(){$.switcher();});
      }
    });
  }

   /******** searching ********/
   $(document).on('keyup', '#search', delay(function() {
        var query = $('#search').val();

        if (query.length < 2 && query.length != 0) {
            return;
        }

        var column_name = $('.sorting').val();
        var sort_type   = $('#hidden_sort_type').val();
        var page        = 1 ? 1 : (this).attr('href').split('page=')[1];
        var account_type      = $('#account_type').val();
        var accounting_groups = $('#accounting_groups').val();

        fetch_data(page, sort_type, column_name, query,account_type,accounting_groups);
    }, 700));

    $('body').on('change', '.sorting', function(){

      var column_name = $(this).val();
      console.log('perpage',column_name);
      var order_type = $(this).data('sorting_type');
      var reverse_order = '';
      var page = 1?1:(this).attr('href').split('page=')[1];
      var query = $('#search').val()?$('#search').val():'';
      var account_type      = $('#account_type').val();
      var accounting_groups = $('#accounting_groups').val();
      fetch_data(page, reverse_order, column_name, query,account_type,accounting_groups);
    });

    $('body').on('change', '.accounting_groups', function(){

      var column_name = $('.sorting').val();
      console.log('perpage',column_name);
      var order_type = $(this).data('sorting_type');
      var reverse_order = '';
      var page = 1?1:(this).attr('href').split('page=')[1];
      var query = $('#search').val()?$('#search').val():'';
      var account_type      = $('#account_type').val();
      var accounting_groups = $('#accounting_groups').val();
      fetch_data(page, reverse_order, column_name, query,account_type,accounting_groups);
    });

    $('body').on('change', '.account_type', function(){

      var column_name = $('.sorting').val();
      console.log('perpage',column_name);
      var order_type = $(this).data('sorting_type');
      var reverse_order = '';
      var page = 1?1:(this).attr('href').split('page=')[1];
      var query = $('#search').val()?$('#search').val():'';
      var account_type      = $('#account_type').val();
      var accounting_groups = $('#accounting_groups').val();
      fetch_data(page, reverse_order, column_name, query,account_type,accounting_groups);
    });

    $('body').on('click', '.pager a', function(event){
      event.preventDefault();
      console.log('url', $(this).attr('href'));
      var page = $(this).attr('href').split('page=')[1];
      $('#hidden_page').val(page);
      var column_name       = $('.sorting').val()?$('.sorting').val():'';
      var sort_type         = $('#hidden_sort_type').val();
      var query             = $('#search').val()?$('#search').val():'';
      var account_type      = $('#account_type').val();
      var accounting_groups = $('#accounting_groups').val();
      $('li').removeClass('active');
      $(this).parent().addClass('active');
      fetch_data(page, sort_type, column_name, query,account_type,accounting_groups);
    });

   
/*********delete data**********/
  $("body").on("click", '.deleteDataCustom', function(event) {
      var UrlValue = $(this).data('url');

      Swal.fire({
          title: 'Are you sure you want to delete this?',
          icon: 'warning',
          showDenyButton: true,
          showCancelButton: false,
          confirmButtonText: 'Yes',
          denyButtonText: 'No',
      }).then((result) => {
          if (result.isConfirmed) {
              $.ajax({
                  url: UrlValue,
                  method: 'delete',
                  data: {
                      "_token": $('meta[name="csrf-token"]').attr('content'),
                      "id": $(this).data('id')
                  },
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  },
                  success: function(response) {
                      if (response.success) {
                     
                          $(this).Toastshow('success', response.message);

                          // Refreshing data after deletion
                          var page = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                          var column_name = $('.sorting').val() ? $('.sorting').val() : '';
                          var sort_type = $('#hidden_sort_type').val();
                          var query = $('#search').val() ? $('#search').val() : '';

                          fetch_data(page, sort_type, column_name, query);
                      } else {
                          // Handle failure case
                          var ErroMsg = $(this).printErrorMsg(response.message);
                          $(this).Toastshow('error', ErroMsg);
                      }
                  },
                  error: function(data) {
                      console.log("error ", data);
                  }
              });
          }
      });
  });


 /*********change status**********/
  $("body").on("click",'.changeStatusCustom', function(event){
          dataString       = {"id":$(this).data('id'),"status":$(this).data('status')};
          var UrlValue     = $(this).data('url');
          var status       = $(this).data('status');
          var changeStatus = $(this);
          var btn = $(this);

          Swal.fire({
              title: 'Are you sure you want to change status?',
              icon: 'warning',
              showDenyButton: true,
              showCancelButton: false,
              confirmButtonText: 'Yes',
              denyButtonText: 'No',
          }).then((result) => {
              if (result.isConfirmed) {
                  $.ajax({
                      url     : UrlValue,
                      method  : 'post',
                      data    :dataString,
                      headers:
                      {
                          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                      },
                      beforeSend: function( xhr ) {
                          // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                      },
                      success : function(response){
                          if(response.success){
                              var ErroMsg = $(this).printErrorMsg(response.message);
                              $(this).Toastshow('success',ErroMsg);

                              var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                              var column_name = $('.sorting').val()?$('.sorting').val():'';
                              var sort_type   = $('#hidden_sort_type').val();
                              var query       = $('#search').val()?$('#search').val():'';

                              fetch_data(page, sort_type, column_name, query);
                          } else {
                              var ErroMsg = $(this).printErrorMsg(response.message);
                              if (ErroMsg === '') {
                                  ErroMsg = "Something went wrong!";
                              }
                              $(this).Toastshow('error',ErroMsg);

                              if (status == 1) {
                                  changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                              } else {
                                  changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                              }
                          }
                      },
                      error: function (data) {
                          console.log("error ",data);

                          if (status == 1) {
                              changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                          } else {
                              changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                          }
                      }
                  });
              }
              else if (result.isDenied) {
                var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                var column_name = $('.sorting').val()?$('.sorting').val():'';
                var sort_type   = $('#hidden_sort_type').val();
                var query       = $('#search').val()?$('#search').val():'';

                fetch_data(page, sort_type, column_name, query);
              }
              //return false;
          });
  });

// Create Study Materials Modal
$(document).on('click', '#create_study_materials', function() {
    $('#commonModalLabel').text('New Study Materials');
    $('.save_button_span').text('Save Study Materials');
    $(".modal-dialog").addClass("modal-lg");
    $.ajax({
        url: "{{ route('study-materials-create') }}?course_id={{$course->id}}&material_type_id={{$material_type_id}}",
        success: function(data) {
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
            $('#description').summernote();
        }
    })
});

//Create Study Material
$(document).on('click','.save_button', function(e) {
  e.preventDefault();

  var error = 0;

  if ($('#commonModal').find('form').hasClass('create_study_materials')) {
      if (error == 0) {
          let formdata = new FormData($('#create_study_materials_form')[0]);
          $.ajax({
              url: $('#create_study_materials_form').attr('action'),
              data: formdata,
              processData: false,
              contentType: false,
              type: 'POST',
              success: function (response) {
                  if (response.success === true) {
                      toastr.success(response.message, 'Success.');
             

                      // hide modal
                      $('#commonModal').modal('hide');
                      $('#commonModal').find('.modal-body').html('');

                       // Refreshing data after deletion
                          var page = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                          var column_name = $('.sorting').val() ? $('.sorting').val() : '';
                          var sort_type = $('#hidden_sort_type').val();
                          var query = $('#search').val() ? $('#search').val() : '';

                          fetch_data(page, sort_type, column_name, query);
                      } else {
                          // Handle failure case
                          var ErroMsg = $(this).printErrorMsg(response.message);
                          $(this).Toastshow('error', ErroMsg);
                      }

              }
          })
          .fail(function(jqXHR, textStatus, errorThrown) {
              console.log('AJAX request failed:', textStatus, errorThrown);
              toastr.error('An error occurred during the request.', 'Error!');
          });
      }
  }

  if ($('#commonModal').find('form').hasClass('edit_study_materials')) {
      if (error == 0) {
          $.ajax({
              url: $('#edit_study_materials_form').attr('action'),
              data: $('#edit_study_materials_form').serialize(),
              // processData: false,
              // contentType: false,
              type: 'PUT',
              success: function (response) {
                  if (response.success === true) {
                      toastr.success(response.message, 'Success.');
                      $('#commonModal').modal('hide');
                      $('#commonModal').find('.modal-body').html('');
                      // Refreshing data after deletion
                          var page = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                          var column_name = $('.sorting').val() ? $('.sorting').val() : '';
                          var sort_type = $('#hidden_sort_type').val();
                          var query = $('#search').val() ? $('#search').val() : '';

                          fetch_data(page, sort_type, column_name, query);
                      } else {
                          // Handle failure case
                          var ErroMsg = $(this).printErrorMsg(response.message);
                          $(this).Toastshow('error', ErroMsg);
                      }
              }
          })
          .fail(function(jqXHR, textStatus, errorThrown) {
              console.log('AJAX request failed:', textStatus, errorThrown);
              toastr.error('An error occurred during the request.', 'Error!');
          });
      }
  }
})


// Edit Study Materials Modal 
$(document).on('click', '#edit_study_materials', function() {
    var id = $(this).data('id');
     $('#commonModalLabel').text('Edit Study Materials');
        $('.save_button_span').text('Update Study Materials');
        $(".modal-dialog").addClass("modal-lg");
        var url = `{!! route('study-materials.edit', ':id') !!}`.replace(':id', id);

        $.ajax({
            url: url,
            success: function(data) {
                $('#commonModal').find('.modal-body').html('');
                $('#commonModal').find('.modal-body').html(data);
                $('#description').summernote();
            }
        });
});


</script>
@endsection
