<form class="row g-3 auto-width" action="{{ route('style-types.update', $data->id) }}" method="post">
    @csrf
    @method('put')

    <div class="col-md-6 col-12">
        <label for="name" class="form-label">Style Name<span class="text-danger"><b>*</b></span></label>
        <input type="text" value="{{ $data->name }}" class="form-control name" id="name" name="name" aria-describedby="inputGroupPrepend" placeholder="Style Name">
        <span class="text-danger error_style_type_name" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-3 col-sm-6 col-12">
        <label for="font_color" class="form-label">Font Color</label>
        <input type="color" value="{{ $data->font_color }}" class="form-control font_color" id="font_color" name="font_color" aria-describedby="inputGroupPrepend"placeholder="Font Color">
    </div>

    <div class="col-md-3 col-sm-6 col-12">
        <label for="background_color" class="form-label">BG Color</span></label>
        <input type="color" value="{{ $data->bg_color }}" class="form-control background_color" id="background_color" name="bg_color" aria-describedby="inputGroupPrepend" placeholder="Background Color">
    </div>

    <div class="col-md-6 col-12">
        <label for="font_color" class="form-label">Code</label>
        <input type="text" value="{{ $data->code }}" class="form-control code" id="code" name="code" aria-describedby="inputGroupPrepend"placeholder="Code">
    </div>

    <div class="col-md-6 col-12">
        <label for="text_decoration" class="form-label">Text Decoration
        </label>
        <select id="text_decoration" name="text_decoration" class="form-control form-select">
            <option {{ ($data->text_decoration == 'none') ? 'selected' : '' }} value="none">None</option>
            <option {{ ($data->text_decoration == 'underline') ? 'selected' : '' }} value="underline">Underline</option>
            <option {{ ($data->text_decoration == 'overline') ? 'selected' : '' }} value="overline">Overline</option>
            <option {{ ($data->text_decoration == 'line-through') ? 'selected' : '' }} value="line-through">Line Through</option>
            <option {{ ($data->text_decoration == 'blink') ? 'selected' : '' }} value="blink">Blink</option>
        </select>
    </div>

    <div class="col-md-12 col-12">
        <label for="font_family" class="form-label">Font Family
        </label>
        <select id="font_family" name="font_family" class="form-control form-select">
            @foreach ($fonts as $font)
                <option {{ ($data->font_family == $font->id) ? 'selected' : '' }} value="{{ $font->id }}">{{ $font->font_name }}</option>
            @endforeach
        </select>
    </div>

    <div class="col-md-4 col-12">
        <label for="font_size" class="form-label">Font Size
        </label>
        <select id="font_size" name="font_size" class="form-control form-select">
            <option {{ ($data->font_size == '10') ? 'selected' : '' }} value="10">10px</option>
            <option {{ ($data->font_size == '11') ? 'selected' : '' }} value="11">11px</option>
            <option {{ ($data->font_size == '12') ? 'selected' : '' }} value="12">12px</option>
            <option {{ ($data->font_size == '13') ? 'selected' : '' }} value="13">13px</option>
            <option {{ ($data->font_size == '14') ? 'selected' : '' }} value="14">14px</option>
            <option {{ ($data->font_size == '15') ? 'selected' : '' }} value="15">15px</option>
            <option {{ ($data->font_size == '16') ? 'selected' : '' }} value="16">16px</option>
            <option {{ ($data->font_size == '17') ? 'selected' : '' }} value="17">17px</option>
            <option {{ ($data->font_size == '18') ? 'selected' : '' }} value="18">18px</option>
            <option {{ ($data->font_size == '19') ? 'selected' : '' }} value="19">19px</option>
            <option {{ ($data->font_size == '20') ? 'selected' : '' }} value="20">20px</option>
        </select>
    </div>

    <div class="col-md-4 col-12">
        <label for="font_style" class="form-label">Font Style
        </label>
        <select id="font_style" name="font_style" class="form-control form-select">
            <option {{ ($data->font_style == 'normal') ? 'selected' : '' }} value="normal">Normal</option>
            <option {{ ($data->font_style == 'italic') ? 'selected' : '' }} value="italic">Italic</option>
        </select>
    </div>

    <div class="col-md-4 col-12">
        <label for="font_weight" class="form-label">Font Weight
        </label>
        <select id="font_weight" name="font_weight" class="form-control form-select">
            <option {{ ($data->font_weight == 'normal') ? 'selected' : '' }} value="normal">Normal</option>
            <option {{ ($data->font_weight == 'bold') ? 'selected' : '' }} value="bold">Bold</option>
        </select>
    </div>

    <div class="col-md-6 col-12">
        <label for="flag" class="form-label">Flag
        </label>
        <input type="text" value="{{ $data->flag }}" class="form-control name" id="flag" name="flag" aria-describedby="inputGroupPrepend" placeholder="Flag">
    </div>

    <div class="col-md-6 col-12">
        <label for="font_padding" class="form-label">Padding
        </label>
        <input type="text" value="{{ $data->font_padding }}" class="form-control name" id="font_padding" name="font_padding" aria-describedby="inputGroupPrepend" placeholder="Padding">
    </div>

</form>