<div class="table-responsive">
	<table id="example" class="table table-bordered align-middle" style="width:100%">
	    <thead class="table-light">
		    <tr>
		        <th class="thbutton">Sl No</th>
                <th>Style Name</th>
                <th>Code</th>
                <th>Font Family</th>
                <th class="thbutton">Decoration</th>
                <th>Font Size</th>
                <th>Font Style</th>
                <th>Font Weight</th>
                <th>Padding</th>
                <th class="thbutton">Default</th>
                <th class="thbutton">Status</th>
                @if(in_array('style-type-edit', $authRolePermissions))
                    <th class="thbutton">Edit</th>
                @endif
                @if(in_array('style-type-delete', $authRolePermissions))
                    <th class="thbutton">Delete</th>
                @endif
		    </tr>
	    </thead>
	    <tbody>
	    	@php $i=1;@endphp
            @if(count($data)>0)
		    	@foreach ($data as $key => $style)
				    <tr>
				        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td style="white-space: normal; background: {{ $style->bg_color }}; color: {{ $style->font_color }}; font-weight: {{$style->font_weight}}">{{ $style->name }}</td>
				        <td>{{ $style->code }}</td>
		                <td style="font-family: {{ $style->font_name }}">{{ \Str::limit($style->font_name, 15, '...') }}</td>
		                <td style="text-decoration: {{ $style->text_decoration }}">{{ $style->text_decoration }}</td>
		                <td style="font-size: {{ $style->font_size }}px">{{ $style->font_size }}</td>
		                <td style="font-style: {{ $style->font_style }}">{{ $style->font_style }}</td>
		                <td style="font-weight: {{ $style->font_weight }}">{{ $style->font_weight }}</td>
                        <td>{{ $style->font_padding }}</td>
                        <td class="text-center">
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('style-types.isdefault')}}" data-id="{{$style->id}}" data-status="{{$style->is_default=='0' ? '1' : '0'}}" {{ $style->is_default=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
				        <td class="text-center">
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('style-types.changestatus')}}" data-id="{{$style->id}}" data-status="{{$style->status=='0' ? '1' : '0'}}" {{ $style->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(in_array('style-type-edit', $authRolePermissions))
                        <td class="text-center">
                            <button data-id="{{ $style->id }}" class="btn btn-outline-secondary edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square"></i>
                            </button>
                        </td>
                        @endif
                        @if(in_array('style-type-delete', $authRolePermissions))
                        <td class="text-center">
                            <a data-url="{{route('style-types.destroy')}}" data-id="{{$style->id}}" class="btn btn-danger deleteDataCustom" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
				    </tr>
			    @endforeach
			@else
                <tr>
                    <td colspan="13">No Data Found</td>
                </tr>
            @endif
	    </tbody>
	</table>
</div>
<nav class="row align-items-center mt-3">
    <div class="col-md-10">
        {!! $data->onEachSide(0)->render('style-types.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
    </div>
</nav>
</div>
