@extends('layouts.app')
@section('title','Diagnosis Import')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
    .card {
        margin-bottom: 0rem;
    }
    .form-control {
        height: 33px !important;
    }
</style>

    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
      <div class="breadcrumb-title col-md-6"> Diagnosis Import </div>
        <div class="col-md-6">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb justify-content-md-end mb-0">
                <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="121" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
                <li class="breadcrumb-item" aria-current="page">Medical Settings</li>
                <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Diagnosis</li>
                <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Upload Excel</li>
              </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->

    <!-- main -->
    <div class="card style_table shadow-none radius-5 min-height">

        <div class="card-header py-3">

            @include('layouts.partials.nav-menu')

            <div class="row gx-2">

                <div class="col-lg-12 col-md-12">
                    <div class="ms-auto float-md-end">
                        @if(auth()->user()->can('symptoms-export'))
                            <a href="{{ asset('admin/excel_demo/symptom-format.xlsx') }}" download class="btn btn-success"><i class="bi bi-download"></i> Download Excel Format</a>
                        @endif
                        <div class="btn-group">
                            <a href="{!! route('symptoms.index') !!}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                        </div>
                    </div>
              </div>
            </div>

        </div>

        <input type="hidden" name="hidden_page" id="hidden_page" value="1"/>
        <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name"/>
        <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc"/>
    </div>
    <!-- end main -->

    <div class="row auto">
        <div class="col-xl-12 mx-auto">
            <div class=" shadow-none radius-5 min-height">
                <div class="">
                    <div class="">
                       <form class="row g-3 auto-width form" action="{{ route('symptoms.import-store') }}" enctype="multipart/form-data" method="POST">
                        @csrf
                        @method('post')
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body g-3 row">
                                    <h5 class="mb-0">Upload Diagnosis From Excel</h5>
                                    <hr class="mb-0">
                                    <div class="col-md-3"></div>

                                    <div class="col-md-6">
                                        <img src="{!! asset('admin/images/upload.png') !!}" style="margin-left: 157px;" width="150" height="150" class="my-3">
                                        <br>
                                    </div>
                                    <div class="col-md-3"></div>

                                    <div class="col-md-3"></div>
                                    <div class="col-md-6">
                                        <label class="form-label">Diagnosis Types<span class="text-danger"><b>*</b></span></label>
                                        <select class="form-select" id="symptoms_type" name="symptoms_type" aria-controls="example">
                                            <option value="">Select Diagnosis Type</option>
                                            @foreach ($symptom_classifications as $key => $list)
                                                <option value="{!! $list->id !!}">{{ $list->symptoms_type }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-3"></div>
                                    <div class="col-md-3"></div>
                                    <div class="col-md-6">
                                        <label for="users">Upload Excel File <span class="text-danger"><b>*</b></span></label>
                                        <input type="file" class="form-control import_excel" name="symptoms"/>
                                    </div>
                                    <span class="text-danger error_import_excel" style="display:none;">This field is required.</span>
                                    <div class="col-md-3"></div>
                                    <div class="col-12 d-flex justify-content-center mb-3">
                                        <button type="submit" style="width: 50%;" class="btn btn-primary">
                                            <i class="bi bi-upload"></i> Upload Diagnosis
                                        </button>
                                    </div>
                                </div>

                                <div class="col-12 justify-content-center mb-3">
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="panelsStayOpen-headingTwo">
                                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false" aria-controls="panelsStayOpen-collapseTwo">
                                                Guidelines For Diagnosis Upload:
                                            </button>
                                        </h2>
                                        <div id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse" aria-labelledby="panelsStayOpen-headingTwo">
                                            <div class="accordion-body">
                                                <strong>Note:</strong><br>
                                                <p>Duplicate records will not be saved.<br>If a record already exists, only that record will be skipped.</p>
                                                <strong>1. Diagnosis Title (required):</strong><br>
                                                <p>Enter the full Diagnosis Title (mandatory, unique).</p>
                                                <strong>2. Diagnosis Type (required):</strong><br>
                                                <p>Enter the Diagnosis Type (mandatory).</p>
                                                <strong>3. Description (optional):</strong><br>
                                                <p>Optionally, provide a description if applicable.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script>

$(document).on('change', '.import_excel', function(){

	var ext = this.value.match(/\.(.+)$/)[1];

    if(ext != 'xls' && ext != 'xlsx'){
        toastr.error('File must be type of xls & xlsx.');
        this.value = '';
    }
    
	const size = (this.files[0]).size;
         
    if (size > 5e+6) {
        toastr.error('File must be less than 5 MB');
        this.value = '';
    }

	var formData = new FormData($('.form')[0]);

    $('#commonModalLabel').text('Excel File Preview');
    $('.save_button_span').text('Close');
    $('.bx-save').switchClass('bx bx-save', 'bi bi-x-lg');
    $('.save_button').attr('data-bs-dismiss','modal');
    $('.modal-dialog').css('max-width', '1000px')
    $.ajax({
        url:"{!! route('symptoms.import-preview') !!}",
        type:'POST',
       	data: formData,
       	contentType: false,
      	processData: false,
        success:function(data){
        	if (data.success === false){
                $('.import_excel').val('');
                toastr.error(data.message);
            } else {
                $('#commonModal').modal('show');
                $('#commonModal').find('.modal-body').html('');
                $('#commonModal').find('.modal-body').html(data);
            }
        }
    });
});

$(document).on('click', '.import_button', function(event){
	$('.error_import_package').hide();
	var error = 0;

	if ($('.import_excel').val() == '') {
		$('.error_import_excel').show();
		error = 1;
	}

	if (error == 0) {
		$('.form').submit();
	}
	error = 1;
});

</script>
@endsection
