<div class="table-responsive">
	<table id="example" class="table table-bordered align-middle" style="width:100%">
	    <thead class="table-light">
		    <tr>
		        <th class="thbutton">Sl No</th>
		        <th>Name</th>
		        <th>Type</th>
		        <th>Description</th>
		        <th class="thbutton">Status</th>
		        @if(auth()->user()->can('symptoms-edit'))
		        	<th class="thbutton">Edit</th>
		        @endif
		        @if(auth()->user()->can('symptoms-delete'))
		        	<th class="thbutton">Delete</th>
		        @endif
		    </tr>
	    </thead>
	    <tbody> 
	    	@php $i=1;@endphp
            @if(count($data)>0)
		    	@foreach ($data as $key => $symptom)
				    <tr>
				        <td class="text-center">{{$data->firstItem() + $key}}</td>
				        <td>{{ $symptom->symptoms_title }} 
							@if(isset($symptom->code))
							({{ $symptom->code }})
							@endif
						</td>
				        <td>{{ $symptom->symptoms_type }}</td>
				        <td style="white-space: normal;">{{ $symptom->description }}</td>
				        <td class="text-center">
                            <div class="form-check form-check-inline{{$i}}">
                                <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('symptoms.changestatus')}}" data-id="{{$symptom->id}}" data-status="{{$symptom->status=='0' ? '1' : '0'}}" {{ $symptom->status=='1' ? 'checked' : ''}}>
                            </div>
                        </td>
                        @if(auth()->user()->can('symptoms-edit'))
                        <td class="text-center">
                            <button data-id="{{ $symptom->id }}" class="btn btn-outline-secondary edit" data-bs-toggle="modal" data-bs-target="#commonModal" title="Edit">
                                <i class="bi bi-pencil-square"></i>
                            </button>
                        </td>
                        @endif
                        @if(auth()->user()->can('symptoms-delete'))
                        <td class="text-center">
                            <a data-url="{{route('symptoms.destroy')}}" data-id="{{$symptom->id}}" class="btn btn-danger deleteDataCustom" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
				    </tr>
			    @endforeach
			@else
                <tr>
                    <td colspan="7">No Data Found</td>
                </tr>
            @endif
	    </tbody>
	</table>
</div>


<nav class="row align-items-center mt-2">
    <div class="col-md-8">
        {!! $data->onEachSide(0)->render('symptoms.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
    </div>
    @if(auth()->user()->can('symptoms-import'))
        <div class="col-lg-2 col-md-2 col-2" style="text-align: right;">
            <div class="btn-group mb-0">
                <a class="btn btn-outline-primary" href="{!! route('symptoms.import-create') !!}"><i class="bi bi-upload"></i> Upload from Excel</a>
            </div>
        </div>
    @endif
</nav>
</div>