<div class="table-responsive">
    <div class="d-flex justify-content-between">
        <h5 class="mb-0"><!-- Responsible Team --></h5>
        @if(auth()->user()->can('responsible-team-create'))
        <button type="button" class="btn btn-primary" id="createtaskEntry"  data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New</button>
        @endif
    </div>
    <hr class="mb-2">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Assign From</th>
                <th>Assigned Date</th>
                <th>Expected Completion Date</th>
                <th>Actual Completion Date</th>
                <th>Reject Reason</th>
                <th>Approval Status</th>
                <th width="10%">Status</th>
                @if(in_array('responsible-team-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(in_array('responsible-team-delete', $authRolePermissions))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;
            @endphp
            @if(isset($taskEntry))
                @foreach($taskEntry as $key=> $list)
                <tr>
                    <td class="text-center">{{ $key + 1}}</td>
                    {{-- <td>{{ucfirst($list->getTask->title ?? '')}}</td> --}}
                    <td>{{ucfirst( $list->getAssignTo->name) ?? ''}} <br> {{$list->getAssignTo->email ?? ''}}</td>
                    <td>{{formatedDate($list->assigned_date )}} </td>
                    <td>{{formatedDate($list->expected_completion_date )}} </td>
                    <td>{{formatedDate($list->actual_completion_date )}} </td>
                    <td>{{ $list->task_accepted_status == 2 ? $list->reject_reason : '' }} </td>
                    <td>
                        @if($list->assigned_to_id == \Auth()->id() && $list->task_accepted_status == '0')
                            <select class="form-control team-approval" data-id="{!! $list->id !!}">
                                <option value="0">Pending</option>
                                <option value="1">Accept</option>
                                <option value="2">Reject</option>
                            </select>
                        @else
                            <span class="badge bg-{!! ($list->task_accepted_status == 2 ? 'danger' : ($list->task_accepted_status == 1 ? 'success' : 'info')) !!}">{!! $list->task_accepted_status == 1 ? 'Accepted' : ($list->task_accepted_status == 2 ? 'Rejected' : 'Pending') !!}</span>
                        @endif
                    </td>
                    <td>
                        <div class="form-check form-check-inline{{$i}}">
                            <input class="form-check-input{{$i}} btn-lg changeStatusCustom" type="checkbox" id="inlineCheckbox{{$i}}" data-url="{{route('task-entry.changestatus')}}" data-id="{{$list->id}}" data-status="{{$list->status=='0' ? '1' : '0'}}" {{ $list->status=='1' ? 'checked' : ''}}>
                        </div>
                    </td>
                    @if(in_array('responsible-team-edit', $authRolePermissions))
                    <td style="font-size: 5px;">
                        <button type="button" class="btn btn-outline-secondary" data-id="{!! $list->id !!}" id="taskEntryEdit"  data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bi bi-pencil-square"></i></i></button>
                    </td>
                    @endif
                    @if(in_array('responsible-team-delete', $authRolePermissions))
                    <td class="text-center">
                        <a data-url="{{route('task-entry.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteAccountData task_entry" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                            <i class="bi bi-trash text-white"></i>
                        </a>
                    </td>
                    @endif
                </tr>
                    @php $i++; @endphp
                @endforeach
            @else
            <tr>
                <td colspan="12">No Data Found</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>
</div>

