<form class="row g-3 auto-width" action="{{ route('product-attributes.store') }}" method="post" enctype='multipart/form-data'
    id="source_form">
    @csrf
    <div class="col-md-12">
        <label for="name" class="form-label">Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="name" name="name" aria-describedby="inputGroupPrepend"
            required>
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-12">
        <label for="code" class="form-label">Code <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="code" name="code" aria-describedby="inputGroupPrepend" required>
        <span class="text-danger error_code" style="display:none;">This field is required.</span>
    </div>
    
    <div class="col-md-6">
        <label for="product_attribute_type_id" class="form-label">Product Attribute Type <span class="text-danger"><b>*</b></span></label>
        <select class="form-control" name="product_attribute_type_id" id="product_attribute_type_id">
            @foreach ($pat as $list)
                <option value="{{ $list->id }}">{{ $list->name }}</option>
            @endforeach
        </select>
        <span class="text-danger error_product_attribute_type_id" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="priority" class="form-label">Priority <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" name="priority" aria-describedby="inputGroupPrepend" required value="{!! $priority + 1 !!}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-12">
        <label for="description" class="form-label">Description</label>
        <textarea class="form-control" max=100 id="description" name="description"></textarea>
    </div>
</form>
