<form class="row g-3 auto-width task_types" action="{{ route('task-manager.store')}}" method="post" enctype='multipart/form-data'>
    @csrf
     <!-- Title -->
     <div class="col-md-12">
        <label for="title" class="form-label">Task Short Details <span class="text-danger"><b>*</b></span></label>
        <textarea class="form-textarea" id="title" name="title" rows="2" placeholder="Task Short Details"></textarea>

        @if ($errors->has('title'))
        <span class="text-danger">{{ $errors->first('title') }}</span>
        @endif
        <span class="text-danger error_title" style="display: none;">This field is required.</span>
    </div>
     <!-- Account-->
    <div class="col-md-12">
        <div>
            <label class="form-label">Client Name</label>
        </div>
        <div class="input-group autocomplete">
            <input type="text" name="" id="account_id" class="account-select form-control" placeholder="Search Client">
            <ul class="searchResult"></ul>
            <input type="hidden" name="account_id" value="">
        </div>
        <span class="text-danger error_account_id" style="display:none;">This field is required.</span>
    </div>
    <!-- Task  Type-->
    <div class="col-md-6">
        <div>
            <label for="task_group_id" class="form-label">Task Group</label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="task_group_id">
                <option value="">--Select Group --</option>
                @foreach($task_groups as $list)
                <option value="{{ $list->id }}">{{ $list->name }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_task_group_id" style="display: none;">This field is required.</span>
    </div>
    <!-- Task  Type-->
    <div class="col-md-6">
        <div>
            <label for="task_status_id" class="form-label">Pipeline Stage</label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="task_status_id">
                <option value="">--Select Stage --</option>
                @foreach($stages as $list)
                <option value="{{ $list->id }}">{{ $list->name }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_task_status_id" style="display: none;">This field is required.</span>
    </div>
     <!-- Title Details-->
     <div class="col-md-12">
        <label class="form-label">Description</label>
        <textarea class="form-textarea" id="details" name="details" rows="2" placeholder="Task Short Details"></textarea>
        @if ($errors->has('details'))
        <span class="text-danger">{{ $errors->first('details') }}</span>
        @endif
        <span class="text-danger error_details" style="display: none;">This field is required.</span>
    </div>
    <!-- date-->
    <div class="col-md-6"  style="z-index: 1500;">
        <div><label for="date" class="form-label">Task Date <span class="text-danger"><b>*</b></span></label></div>
        <div class="input-group">
            <input type="text" name="date" class="form-control" id="date" autocomplete="off" readonly style="cursor: pointer;" value="{!! date('d-m-Y') !!}">
        </div>
        @if ($errors->has('date'))
            <span class="text-danger">{{ $errors->first('date') }}</span>
        @endif
    </div>
    <!-- deadline-->
    <div class="col-md-6"  style="z-index: 1500;">
        <div><label for="deadline" class="form-label"> Deadline </span></label></div>
        <div class="input-group">
            <input type="" name="deadline" class="form-control" id="deadline" autocomplete="off" readonly style="cursor: pointer;">
        </div>
        @if ($errors->has('deadline'))
            <span class="text-danger">{{ $errors->first('deadline') }}</span>
        @endif
    </div>
    <!-- Project-->
    <div class="col-md-6">
        <div>
            <label for="project_id" class="form-label">Projects</label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="project_id">
                <option value="">--Select Project --</option>
                @foreach($project as $list)
                <option value="{{ $list->id }}">{{ $list->title }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_project_id" style="display: none;">This field is required.</span>
    </div>
    <!-- Task  Type-->
    <div class="col-md-6">
        <div>
            <label for="task_type_id" class="form-label">Task Type</label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="task_type_id">
                <option value="">--Select Type --</option>
                @foreach($taskType as $list)
                <option value="{{ $list->id }}">{{ $list->title }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_task_type_id" style="display: none;">This field is required.</span>
    </div>
    <!-- Amount-->
    <div class="col-md-6">
        <label class="form-label">Amount</label>
        <input type="number" class="form-control" id="amount" name="amount" aria-describedby="inputGroupPrepend" required value="0">
        @if ($errors->has('amount'))
        <span class="text-danger">{{ $errors->first('amount') }}</span>
        @endif
        <span class="text-danger error_amount" style="display: none;">This field is required.</span>
    </div>
    <!-- Amount-->
    <div class="col-md-6">
        <label class="form-label">Points</label>
        <input type="decimal" class="form-control" id="task_point" name="task_point" aria-describedby="inputGroupPrepend" required value="1">
        @if ($errors->has('task_point'))
        <span class="text-danger">{{ $errors->first('task_point') }}</span>
        @endif
        <span class="text-danger error_task_point" style="display: none;">This field is required.</span>
    </div>
    <!-- privacy_type-->
    <div class="col-md-6">
        <label class="form-label">Privacy Type</label>
        <select class="single-select form-control" name="privacy_type">
            <option value="1">Team</option>
            <option value="2">Private</option>
        </select>
        @if ($errors->has('privacy_type'))
        <span class="text-danger">{{ $errors->first('privacy_type') }}</span>
        @endif
        <span class="text-danger error_privacy_type" style="display: none;">This field is required.</span>
    </div>
    <!-- payment_status-->
    <div class="col-md-6">
        <label class="form-label">Payment Status</label>
        <select class="single-select form-control" name="payment_status">
            <option value="0">UnPaid</option>
            <option value="1">Paid</option>
        </select>
        @if ($errors->has('payment_status'))
        <span class="text-danger">{{ $errors->first('payment_status') }}</span>
        @endif
        <span class="text-danger error_privacy_type" style="display: none;">This field is required.</span>
    </div>
</form>
