<form class="row g-3 auto-width" action="{{ route('task-manager.update', $data->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('PUT')
    <!-- Title -->
    <div class="col-md-12">
        <label for="title" class="form-label">Task Short Details </label>
        <input type="text" class="form-control" id="title" name="title" aria-describedby="inputGroupPrepend" required value="{{$data->title}}">
        @if ($errors->has('title'))
        <span class="text-danger">{{ $errors->first('title') }}</span>
        @endif
        <span class="text-danger error_title" style="display: none;">This field is required.</span>
    </div>
    <!-- Task  Type-->
    <div class="col-md-6">
        <div>
            <label for="task_group_id" class="form-label">Task Group</label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="task_group_id">
                <option value="">--Select Group --</option>
                @foreach($task_groups as $list)
                <option value="{{ $list->id }}" {!! matchSelected($data->task_group_id, $list->id) !!}>{{ $list->name }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_task_group_id" style="display: none;">This field is required.</span>
    </div>
    <!-- Task  Type-->
    <div class="col-md-6">
        <div>
            <label for="task_status_id" class="form-label">Pipeline Stage</label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="task_status_id">
                <option value="">--Select Stage --</option>
                @foreach($stages as $list)
                <option value="{{ $list->id }}" {!! matchSelected($data->task_status_id, $list->id) !!}>{{ $list->name }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_task_status_id" style="display: none;">This field is required.</span>
    </div>
     <!-- Account -->
     <div class="col-md-12">
        <div>
            <label class="form-label">Client Name</label>
        </div>
        <div class="input-group autocomplete">
            <input type="text" name="" id="account_id" class="account-select form-control" placeholder="Search Account" value="{!! $data->getAccount->name ?? '' !!}">
            <ul class="searchResult"></ul>
            <input type="hidden" name="account_id" value="">
        </div>
        <span class="text-danger error_account_id" style="display:none;">This field is required.</span>
    </div>
    <!-- Title Details-->
    <div class="col-md-12">
        <label class="form-label">Description</label>
        <textarea class="form-control" max=100 id="details" name="details"> {{$data->details}}</textarea>
        @if ($errors->has('details'))
        <span class="text-danger">{{ $errors->first('details') }}</span>
        @endif
        <span class="text-danger error_details" style="display: none;">This field is required.</span>
    </div>
    <!-- date-->
    <div class="col-md-6"  style="z-index: 1500;">
        <div><label for="date" class="form-label">Task Date </label></div>
        <div class="input-group">
            <input type="" name="date" class="form-control" id="date" autocomplete="off"  readonly style="cursor: pointer;" required value="{{ !empty($data->date) ? date($companyDateFormate, strtotime($data->date)) : '' }}">
        </div>
        @if ($errors->has('date'))
            <span class="text-danger">{{ $errors->first('date') }}</span>
        @endif
    </div>
    <!-- deadline-->
    <div class="col-md-6"  style="z-index: 1500;">
        <div><label for="deadline" class="form-label">Deadline</label></div>
        <div class="input-group">
            <input type="text" name="deadline" class="form-control" id="deadline" autocomplete="off" readonly style="cursor: pointer;"  value="{{ !empty($data->deadline) ? date($companyDateFormate, strtotime($data->deadline)) : '' }}">
        </div>
        @if ($errors->has('deadline'))
            <span class="text-danger">{{ $errors->first('deadline') }}</span>
        @endif
    </div>
    <!-- Project-->
    <div class="col-md-6">
        <div>
            <label for="project_id" class="form-label">Projects</label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="project_id">
                <option value="">--Select Project --</option>
                @foreach($project as $list)
                <option value="{{ $list->id }}" {!! matchSelected($data->project_id, $list->id) !!}>{{ $list->title }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_project_id" style="display: none;">This field is required.</span>
    </div>
    <!-- Task  Type-->
    <div class="col-md-6">
        <div>
            <label for="task_type_id" class="form-label">Task Type</label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="task_type_id">
                <option value="">--Select Type --</option>
                @foreach($taskType as $list)
                <option value="{{ $list->id }}" {!! matchSelected($data->task_type_id, $list->id) !!}>{{ $list->title }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_task_type_id" style="display: none;">This field is required.</span>
    </div>
    <!-- Amount-->
    <div class="col-md-6">
        <label class="form-label">Amount</label>
        <input type="number" class="form-control" id="amount" name="amount" aria-describedby="inputGroupPrepend" required value="{{$data->amount}}">
        @if ($errors->has('amount'))
        <span class="text-danger">{{ $errors->first('amount') }}</span>
        @endif
        <span class="text-danger error_amount" style="display: none;">This field is required.</span>
    </div>
    <!-- Amount-->
    <div class="col-md-6">
        <label class="form-label">Points</label>
        <input type="decimal" class="form-control" id="task_point" name="task_point" aria-describedby="inputGroupPrepend" required value="{{$data->task_point}}">
        @if ($errors->has('task_point'))
        <span class="text-danger">{{ $errors->first('task_point') }}</span>
        @endif
        <span class="text-danger error_task_point" style="display: none;">This field is required.</span>
    </div>
    <!-- completion_date-->
    <div class="col-md-6"  style="z-index: 1500;">
        <div><label for="completion_date" class="form-label">Completion Date </span></label></div>
        <div class="input-group">
            <input type="" name="completion_date" class="form-control" id="completion_date" autocomplete="off" readonly style="cursor: pointer;" value="{{ !empty($data->completion_date) ? date($companyDateFormate, strtotime($data->completion_date)) : '' }}">
        </div>
        @if ($errors->has('completion_date'))
            <span class="text-danger">{{ $errors->first('completion_date') }}</span>
        @endif
    </div>
    <!-- estimated_time-->
    <div class="col-md-6"  style="z-index: 1500;">
        <div><label for="estimated_time" class="form-label">Estimated Time </span></label></div>
        <div class="input-group">
            <input type="" name="estimated_time" class="form-control" id="estimated_time" autocomplete="off" readonly style="cursor: pointer;" value="{{ !empty($data->estimated_time) ? date($companyDateFormate, strtotime($data->estimated_time)) : '' }}">
        </div>
        @if ($errors->has('estimated_time'))
            <span class="text-danger">{{ $errors->first('estimated_time') }}</span>
        @endif
    </div>
    <!-- actual_time-->
    <div class="col-md-6"  style="z-index: 1500;">
        <div><label for="actual_time" class="form-label">Actual Time </span></label></div>
        <div class="input-group">
            <input type="" name="actual_time" class="form-control" id="actual_time" autocomplete="off" readonly style="cursor: pointer;" value="{{ !empty($data->actual_time) ? date($companyDateFormate, strtotime($data->actual_time)) : '' }}">
        </div>
        @if ($errors->has('actual_time'))
            <span class="text-danger">{{ $errors->first('actual_time') }}</span>
        @endif
    </div>
    <!-- privacy_type-->
    <div class="col-md-6">
        <label class="form-label">Privacy Type</label>
        <select class="single-select form-control" name="privacy_type">
            <option value="1" {!! matchSelected($data->privacy_type, '1') !!}>Team</option>
            <option value="2" {!! matchSelected($data->privacy_type, 2) !!}>Private</option>
        </select>
        @if ($errors->has('privacy_type'))
        <span class="text-danger">{{ $errors->first('privacy_type') }}</span>
        @endif
        <span class="text-danger error_privacy_type" style="display: none;">This field is required.</span>
    </div>
    <!-- payment_status-->
    <div class="col-md-6">
        <label class="form-label">Payment Status</label>
        <select class="single-select form-control" name="payment_status">
            <option value="0" {!! matchSelected($data->payment_status, 0) !!}>UnPaid</option>
            <option value="1" {!! matchSelected($data->payment_status, 1) !!}>Paid</option>
        </select>
        @if ($errors->has('payment_status'))
        <span class="text-danger">{{ $errors->first('payment_status') }}</span>
        @endif
        <span class="text-danger error_privacy_type" style="display: none;">This field is required.</span>
    </div>
</form>