@extends('layouts.app')
@section('title','Tasks')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
    .badge{
      color: #222222;
      font-size: 0.7rem;
      border: 1px solid #cccccc;
      margin-top: 2px;
    }
    #ui-datepicker-div {
    z-index: 1500 !important;
    }
    .ui-widget-content{
        z-index: 1500;

    }
</style>
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<!--breadcrumb-->
<div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
  <div class="breadcrumb-title col-md-6"> Tasks
  </div>
  <div class="col-md-6">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb justify-content-md-end mb-0">
        <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="8" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
        <li class="breadcrumb-item" aria-current="page">Task</li>
      </ol>
    </nav>
  </div>
</div>
<!--end breadcrumb-->

<div class="card style_table shadow-none radius-5 min-height">
  <div class="card-header py-3">
    @include('layouts.partials.nav-menu')
    <div class="row gx-2">
      <div class="col-lg-3 col-md-3 col-4">
          <div class="position-relative">
              <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
              <input class="form-control ps-5" type="search" id="search" placeholder="Search By Client Name, Task Title">
          </div>
      </div>

      <div class="col-lg-2 col-md-2 col-4 dataTables_length">
        <i class="bi bi-funnel"></i>
        <select class="form-select taskpriority" id="" name="example_length" aria-controls="example">
          <option value="">Select Task Priority</option>
          @foreach ($taskPriority as $option)
              <option value="{{ $option->id }}">
                  {{ ucfirst($option->name) }}
              </option>
          @endforeach
        </select>
      </div>

      <div class="col-lg-2 col-md-2 col-4 dataTables_length">
        <select class="form-select taskStatus">
            <option value="">Select Task Status</option>
            @foreach ($taskStatus as $option)
                <option value="{{ $option->id }}">
                    {{ ucfirst($option->name) }}
                </option>
            @endforeach
        </select>
      </div>

      <div class="col-lg-2 col-md-2 col-4 dataTables_length">
        <select class="form-select taskTeam">
            <option value="">Select Task Team</option>
            @foreach ($tastTeam as $option)
                <option value="{{ $option->id }}">
                    {{ ucfirst($option->name) }}
                </option>
            @endforeach
        </select>
      </div>

      <div class="col-lg-3 col-md-3">
        <div class="ms-auto float-md-end">

          <div class="btn-group">
            @if(!empty($id))
              <a href="{{route('task-manager.index')}}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
            @else
            {{-- @if(in_array('task-create', $authRolePermissions)) --}}
               <button type="button" class="btn btn-primary" id="create"  data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus"></i> Add New</button>
            {{-- @endif --}}
            @endif
          </div>
        </div>
      </div>
    </div>
  </div>

<!-- <div class="card-body">
  <div class="row gx-2">
    <div class="col-lg-2 col-md-2 col-2 p-4">
        <div class="bg-dark">My Tasks : </div>
    </div>
    <div class="col-lg-2 col-md-2 col-2 p-4">
        <div class="bg-dark">My Tasks : </div>
    </div>
    <div class="col-lg-2 col-md-2 col-2 p-4">
        <div class="bg-dark">My Tasks : </div>
    </div>
    <div class="col-lg-2 col-md-2 col-2 p-4">
        <div class="bg-dark">My Tasks : </div>
    </div>
    <div class="col-lg-2 col-md-2 col-2 p-4">
        <div class="bg-dark">My Tasks : </div>
    </div>
  </div>
</div> -->

<div class="card-body" id="tables">

  @include('task-manager.tasks.table')

  <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
  <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
  <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
</div>
@endsection
@section('js')
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js') }}"></script>
<script>

     /***************** Global Delay Fucntion ***************/
     function delay(callback, ms) {
        var timer = 0;
        return function() {
            var context = this,
                args = arguments;
            clearTimeout(timer);
            timer = setTimeout(function() {
                callback.apply(context, args);
            }, ms || 0);
        };
    }


  $(document).ready(function(){
    function clear_icon(){
      $('#id_icon').html('');
      $('#post_title_icon').html('');
    }
    function fetch_data(page, sort_type, sort_by, query){
      var taskStatus   = $('.taskStatus').val();
      var taskTeam     = $('.taskTeam').val();
      var taskpriority = $('.taskpriority').val();

      $.ajax({
        url:"?page="+page+"&sortby="+sort_by+"&sorttype="+sort_type+"&query="+query+"&taskpriority="+taskpriority+"&taskStatus="+taskStatus+"&taskTeam="+taskTeam,
        success:function(data){
          $('#tables').html('');
          $('#tables').html(data);
          $(document).ready(function(){$.switcher();});
        }
      })
    }
     /******** searching ********/
     $(document).on('keyup', '#search', delay(function() {
        var query = $('#search').val();

        if (query.length < 2 && query.length != 0) {
            return;
        }

        var column_name = $('.sorting').val();
        var sort_type   = $('#hidden_sort_type').val();
        var page        = 1 ? 1 : (this).attr('href').split('page=')[1];
        fetch_data(page, sort_type, column_name, query);
    }, 700));

    $('body').on('change', '.sorting', function(){

      var column_name = $(this).val();
      var order_type = $(this).data('sorting_type');
      var reverse_order = '';
      var page = 1?1:(this).attr('href').split('page=')[1];
      var query = $('#search').val()?$('#search').val():'';
      fetch_data(page, reverse_order, column_name, query);
    });
    $('body').on('click', '.pager a', function(event){
      event.preventDefault();
      var page = $(this).attr('href').split('page=')[1];
      $('#hidden_page').val(page);
      var column_name = $('.sorting').val()?$('.sorting').val():'';
      var sort_type = $('#hidden_sort_type').val();
      var query = $('#search').val()?$('#search').val():'';
      $('li').removeClass('active');
      $(this).parent().addClass('active');
      fetch_data(page, sort_type, column_name, query);
    });

    $(document).on('click', '#create', function() {
        $('#commonModalLabel').text('Add New Task');
        $('.save_button_span').text('Save Task ');
        $.ajax({
          url:"{!! route('task-manager.create') !!}",
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);
            $('.account-select').autocomplete({
                autoFocus: true,
                minLength: 0,
                source: function(request, response) {
                    if (request.term.length < 2) {
                        $('[name="account_id"]').val('');
                        return false;
                    }

                    $.ajax({
                        url: '{{ route('task-client-search') }}',
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            token: '{!! csrf_token() !!}',
                            search_text: request.term
                        },
                        success: function(json) {
                            if (json.error) {
                                $('[name="account_id"]').val('');
                                return false;
                            }
                            response($.map(json.result,
                                function(item) {
                                    return {
                                        id: item.id,
                                        name: item.name,
                                    };
                                }));
                        }
                    });
                },
                select: function(event, ui) {
                    event.preventDefault();
                    $(this).val(ui.item.name);
                    $('[name="account_id"]').val(ui.item.id);
                    return false;
                }
            }).data("ui-autocomplete")._renderItem = function(ul, item) {
                return $("<li>").append("<a>" + item.name + "</a>").appendTo(ul);
            };
                $("#deadline").datepicker({
                  format: "{!! $companyDateFormate ?? 'dd-mm-yyyy' !!}",
                });

                $("#completion_date").datepicker({
                  format: "{!! $companyDateFormate ?? 'dd-mm-yyyy' !!}",
                });

                // $('#date').datepicker({
                //     format: 'dd/mm/yy'
                // });

                $('#date').datepicker({
                    format: "{!! $companyDateFormate ?? 'dd-mm-yyyy' !!}",
                });

                $('#estimated_time').datepicker({
                    format: "{!! $companyDateFormate ?? 'dd-mm-yyyy' !!}",
                });

                $('#actual_time').datepicker({
                    format: "{!! $companyDateFormate ?? 'dd-mm-yyyy' !!}",
                });

                var currentDate = new Date();
                var formattedDate = currentDate.getDate().toString().padStart(2, '0') + '/' + (currentDate.getMonth() + 1).toString().padStart(2, '0') + '/' + currentDate.getFullYear();
                // $('#date').val(formattedDate);
            }

        })
    });

    $(document).on('click', '.edit', function(){
        $('#commonModalLabel').text('Edit Task');
        $('.save_button_span').text('Update Task');
        var id = $(this).data('id');
        var url = `{!! route('task-manager.edit', ':id') !!}`.replace(':id', id);

        $.ajax({
          url:url,
          success:function(data){
            $('#commonModal').find('.modal-body').html('');
            $('#commonModal').find('.modal-body').html(data);

            $("#deadline").datepicker({
              format: "{!! $companyDateFormate ?? 'dd-mm-yyyy' !!}",
            })
            $("#completion_date").datepicker({
              format: "{!! $companyDateFormate ?? 'dd-mm-yyyy' !!}",
            })

            $( "#date" ).datepicker({
              format: "{!! $companyDateFormate ?? 'dd-mm-yyyy' !!}",
            });

            $('.account-select').autocomplete({
                autoFocus: true,
                minLength: 0,
                source: function(request, response) {
                    if (request.term.length < 2) {
                        $('[name="account_id"]').val('');
                        return false;
                    }

                    $.ajax({
                        url: "{{ route('task-client-search') }}",
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            action: 'get_accounts_for_journal_voucher',
                            search_text: request.term
                        },
                        success: function(json) {
                             ;
                            if (json.error) {
                                $('[name="account_id"]').val('');
                                return false;
                            };
                            response($.map(json.result, function(item) {
                                return {
                                    id: item.id,
                                    name: item.name,
                                };
                            }));
                        }
                    });
                },
                select: function(event, ui) {
                     ;
                    event.preventDefault();
                    $(this).val(ui.item.name + "");
                    $('[name="account_id"]').val(ui.item.id);
                    return false;
                }
            }).data("ui-autocomplete")._renderItem = function(ul, item) {
                 ;
                return $("<li>")
                    .append("<a>" + item.name + "</a>")
                    .appendTo(ul);
            };

                $('#estimated_time').datepicker({
                    format: "{!! $companyDateFormate ?? 'dd-mm-yyyy' !!}",
                });

                $('#actual_time').datepicker({
                    format: "{!! $companyDateFormate ?? 'dd-mm-yyyy' !!}",
                });

          }
        })
    })

    $(document).on('click', '.save_button', function(event) {
        event.preventDefault();
        $('.error_title').hide();
        var error = 0;

        if ($('#commonModal').find('form').find('[name="title"]').val() == '') {
            $('.error_title').show();
            error = 1;
        }

        if (error == 0) {
            let formdata = new FormData($('#commonModal').find('form')[0]);

            $.ajax({
                    url: $('#commonModal').find('form').attr('action'),
                    data: formdata,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function(response) {
                        if (response.success === true) {
                            toastr.success(response.message, 'Success.');

                            var page = $('.pager').find('.active a').attr('href') ==
                                undefined ? 1 : $('.pager').find('.active a').attr('href')
                                .split('page=')[1];
                            var column_name = $('.sorting').val() ? $('.sorting').val() :
                            '';
                            var sort_type = $('#hidden_sort_type').val();
                            var query = $('#search').val() ? $('#search').val() : '';

                            fetch_data(page, sort_type, column_name, query);

                            // hide modal
                            $('#commonModal').modal('hide');
                            $('#commonModal').find('.modal-body').html('');
                        } else {
                            toastr.error(response.message, 'Error!');
                        }
                    }
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    console.log('AJAX request failed:', textStatus, errorThrown);
                    toastr.error('An error occurred during the request.', 'Error!');

                    // hide modal
                    $('#commonModal').modal('hide');
                    $('#commonModal').find('.modal-body').html('');
                    $('#commonModal').removeClass('category');
                });
        }
        error = 1;
    })

    /*********delete data**********/
  $("body").on("click", '.deleteDataCustom', function(event) {
      var UrlValue = $(this).data('url');

      Swal.fire({
          title: 'Are you sure you want to delete this?',
          icon: 'warning',
          showDenyButton: true,
          showCancelButton: false,
          confirmButtonText: 'Yes',
          denyButtonText: 'No',
      }).then((result) => {
          if (result.isConfirmed) {
              $.ajax({
                  url: UrlValue,
                  method: 'delete',
                  data: {
                      "_token": $('meta[name="csrf-token"]').attr('content'),
                      "id": $(this).data('id')
                  },
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  },
                  success: function(response) {
                      if (response.success) {

                          $(this).Toastshow('success', response.message);

                          // Refreshing data after deletion
                          var page = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                          var column_name = $('.sorting').val() ? $('.sorting').val() : '';
                          var sort_type = $('#hidden_sort_type').val();
                          var query = $('#search').val() ? $('#search').val() : '';

                          fetch_data(page, sort_type, column_name, query);
                      } else {
                          // Handle failure case
                          var ErroMsg = $(this).printErrorMsg(response.message);
                          $(this).Toastshow('error', ErroMsg);
                      }
                  },
                  error: function(data) {
                      console.log("error ", data);
                  }
              });
          }
      });
  });

    /*********change status**********/
    $("body").on("click",'.changeStatusCustom', function(event){
        dataString       = {"id":$(this).data('id'),"status":$(this).data('status')};
        var UrlValue     = $(this).data('url');
        var status       = $(this).data('status');
        var changeStatus = $(this);
        var btn = $(this);

        Swal.fire({
            title: 'Are you sure you want to change status?',
            icon: 'warning',
            showDenyButton: true,
            showCancelButton: false,
            confirmButtonText: 'Yes',
            denyButtonText: 'No',
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url     : UrlValue,
                    method  : 'post',
                    data    :dataString,
                    headers:
                    {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    beforeSend: function( xhr ) {
                        // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                    },
                    success : function(response){
                        if(response.success){
                            var ErroMsg = $(this).printErrorMsg(response.message);
                            $(this).Toastshow('success',ErroMsg);

                            var page = $('.pager').find('.active a').attr( 'href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                            var column_name = $('.sorting').val() ? $('.sorting').val() : '';
                            var sort_type = $('#hidden_sort_type').val();
                            var query = $('#search').val() ? $('#search').val() : '';

                            fetch_data(page, sort_type, column_name, query);
                        } else {
                            var ErroMsg = $(this).printErrorMsg(response.message);
                            if (ErroMsg === '') {
                                ErroMsg = "Something went wrong!";
                            }
                            $(this).Toastshow('error',ErroMsg);

                            if (status == 1) {
                                changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                            } else {
                                changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                            }
                        }
                    },
                    error: function (data) {
                        console.log("error ",data);

                        if (status == 1) {
                            changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                        } else {
                            changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                        }
                    }
                });
            }
            else if (result.isDenied) {

                var page = $('.pager').find('.active a').attr( 'href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                var column_name = $('.sorting').val() ? $('.sorting').val() : '';
                var sort_type = $('#hidden_sort_type').val();
                var query = $('#search').val() ? $('#search').val() : '';

                fetch_data(page, sort_type, column_name, query);
            }
            //return false;
        });
    //return false;
    });
    $('body').on('change', '.taskStatus, .taskpriority, .taskTeam', function(event){
      event.preventDefault();

      var column_name = $('.sorting').val()?$('.sorting').val():'';
      var page = $('#hidden_page').val();
      var sort_type = $('#hidden_sort_type').val();
      var query = $('#search').val()?$('#search').val():'';

      fetch_data(page, sort_type, column_name, query);
    });
  });


    $(document).on('change', '[name="task_group_id"]', function() {
        $('#commonModalLabel').text('Add New Task');
        $('.save_button_span').text('Save Task ');
        $.ajax({
          url:"{!! route('task-group-stages') !!}",
          data: {
            '_token' : "{!! csrf_token() !!}",
            task_group : $(this).val(),
          },
          type: 'POST',
          success:function(data){
            if (data.success == true) {
              var content = '<option value="">--Select Stage --</option>';

              $.each(data.data, function (index, value) {
                content += '<option value="' + value.id + '">' + value.name + '</option>';
              });

              $('[name="task_status_id"]').html(content);
            }
          }
        })
    });
     $(document).ready(function() {
        $('.taskStatusDropdown').on('change', function () {
            var selectedStatusId = $(this).val();
            var taskId = $(this).data('task-id');

            // Check if the selected value is empty
            if (selectedStatusId === "") {
                toastr.warning('Please select a status.', 'Warning!');
                return;
            }

            $.ajax({
                url: "{{ url('store-task-status') }}/" + taskId,
                method: 'POST',
                data: {
                    task_status_id: selectedStatusId,
                    _token: '{{ csrf_token() }}',
                },
                success: function(response) {
                    if (response.success === true) {
                        toastr.success(response.message, 'Success.');

                        // hide modal
                        $('#commonModal').modal('hide');
                        fetch_project_attachments();
                    } else {
                        toastr.error(response.message, 'Error!');
                    }
                }
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                console.log('AJAX request failed:', textStatus, errorThrown);
                toastr.error('An error occurred during the request.', 'Error!');

                // hide modal
                $('#commonModal').modal('hide');
                $('#commonModal').find('.modal-body').html('');
            });
        });
        $('.taskWorkStatusDropdown').on('change', function () {
            var selectedStatusId = $(this).val();
            var taskId = $(this).data('task-id');

            // Check if the selected value is empty
            if (selectedStatusId === "") {
                toastr.warning('Please select a status.', 'Warning!');
                return;
            }

            $.ajax({
                url: "{{ url('store-task-work-status') }}/" + taskId,
                method: 'POST',
                data: {
                    task_status_id: selectedStatusId,
                    _token: '{{ csrf_token() }}',
                },
                success: function(response) {
                    if (response.success === true) {
                        toastr.success(response.message, 'Success.');

                        // hide modal
                        $('#commonModal').modal('hide');
                        fetch_project_attachments();
                    } else {
                        toastr.error(response.message, 'Error!');
                    }
                }
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                console.log('AJAX request failed:', textStatus, errorThrown);
                toastr.error('An error occurred during the request.', 'Error!');

                // hide modal
                $('#commonModal').modal('hide');
                $('#commonModal').find('.modal-body').html('');
            });
        });


        $('.taskPriorityDropdown').on('change', function () {
            var selectedPriorityId = $(this).val();
            var taskId = $(this).data('task-id');

            $.ajax({
                url: "{{ url('store-task-priority') }}/" + taskId, // Fix this line
                method: 'POST',
                data: {
                    status_id: selectedPriorityId,
                    _token: '{{ csrf_token() }}',
                },
                success: function(response) {
                         if (response.success === true) {
                             toastr.success(response.message, 'Success.');

                             // hide modal
                             $('#commonModal').modal('hide');
                             fetch_project_attachments();
                         } else {
                             toastr.error(response.message, 'Error!');
                         }
                     }
                 })
                 .fail(function(jqXHR, textStatus, errorThrown) {
                     console.log('AJAX request failed:', textStatus, errorThrown);
                     toastr.error('An error occurred during the request.', 'Error!');

                     // hide modal
                     $('#commonModal').modal('hide');
                     $('#commonModal').find('.modal-body').html('');
                 });

        });

        $('.taskPriorityDropdown').on('change', function () {
            var selectedStatusId = $(this).val();
            var taskId = $(this).data('task-id');

            $.ajax({
                url: "{{ url('store-task-status') }}/" + taskId, // Fix this line
                method: 'POST',
                data: {
                    status_id: selectedStatusId,
                    _token: '{{ csrf_token() }}',
                },
                success: function(response) {
                   if (response.success === true) {
                      toastr.success(response.message, 'Success.');

                      var page = $('.pager').find('.active a').attr('href') ==
                          undefined ? 1 : $('.pager').find('.active a').attr('href')
                          .split('page=')[1];
                      var column_name = $('.sorting').val() ? $('.sorting').val() :
                      '';
                      var sort_type = $('#hidden_sort_type').val();
                      var query = $('#search').val() ? $('#search').val() : '';

                      fetch_data(page, sort_type, column_name, query);
                   } else {
                       toastr.error(response.message, 'Error!');
                   }
                }
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
               console.log('AJAX request failed:', textStatus, errorThrown);
               toastr.error('An error occurred during the request.', 'Error!');

            });

        });
     });
</script>
@endsection
