<form class="row g-3 auto-width" action="{{ route('task.update', $data->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('PUT')
    <!-- date-->
    <div class="col-md-6"  style="z-index: 1500;">
        <div><label for="date" class="form-label"> Date </label></div>
        <div class="input-group">
            <input type="" name="date" class="form-control" id="date" autocomplete="off"  readonly style="cursor: pointer;" required value="{{$data->date}}">
        </div>
        @if ($errors->has('date'))
            <span class="text-danger">{{ $errors->first('date') }}</span>
        @endif
    </div>
      <!-- Assign to-->
    <div class="col-md-6">
        <div>
            <label for="assigned_to" class="form-label">Assign To </label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="assigned_to">
                @foreach($assignTo as $list)
                <option value="{{ $list->id }}" {{ $list->id == $data->assigned_to ? 'selected':'' }}>{{ $list->name }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_assigned_to" style="display: none;">This field is required.</span>
    </div>
    <!-- Title -->
    <div class="col-md-12">
        <label for="title" class="form-label">Task Title </label>
        <input type="text" class="form-control" id="title" name="title" aria-describedby="inputGroupPrepend" required value="{{$data->title}}">
        @if ($errors->has('title'))
        <span class="text-danger">{{ $errors->first('title') }}</span>
        @endif
        <span class="text-danger error_title" style="display: none;">This field is required.</span>
    </div>
    <!-- Title Details-->
    <div class="col-md-12">
        <label class="form-label">Details</label>
        <textarea class="form-control" max=100 id="details" name="details"> {{$data->details}}</textarea>
        @if ($errors->has('details'))
        <span class="text-danger">{{ $errors->first('details') }}</span>
        @endif
        <span class="text-danger error_details" style="display: none;">This field is required.</span>
    </div>
     <!-- Account -->
     <div class="col-md-6">
        <div>
            <label class="form-label">Account</label>
        </div>
        <div class="input-group autocomplete">
            <input type="text" name="" id="account_id" class="account-select form-control" placeholder="Search Account" value="{!! $data->getAccount->name ?? '' !!}">
            <ul class="searchResult"></ul>
            <input type="hidden" name="account_id" value="">
        </div>
        <span class="text-danger error_account_id" style="display:none;">This field is required.</span>
    </div>
        {{-- <span class="text-danger error_doctor_id" style="display: none;">This field is required.</span> --}}
    </div>
    <!-- Amount-->
    <div class="col-md-6">
        <label class="form-label">Amount</label>
        <input type="number" class="form-control" id="amount" name="amount" aria-describedby="inputGroupPrepend" required value="{{$data->amount}}">
        @if ($errors->has('amount'))
        <span class="text-danger">{{ $errors->first('amount') }}</span>
        @endif
        <span class="text-danger error_amount" style="display: none;">This field is required.</span>
    </div>
     <!-- Charge ID-->
     <div class="col-md-6">
        <div>
            <label for="charges_id" class="form-label">Charge ID </label>
        </div>
        <div class="input-group">
            <select class="single-select form-control" name="charges_id">
                <option value="">--Select Charge -- </option>
                @foreach($charge_id as $list)
                <option value="{{ $list->id }}" {{ $list->id == $data->charges_id ? 'selected':'' }}>{{ $list->name }}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_charges_id" style="display: none;">This field is required.</span>
    </div>
    <!-- deadline-->
    <div class="col-md-6"  style="z-index: 1500;">
        <div><label for="deadline" class="form-label"> deadline </span></label></div>
        <div class="input-group">
            <input type="" name="deadline" class="form-control" id="deadline" autocomplete="off" readonly style="cursor: pointer;"  value="{{$data->deadline}}">
        </div>
        @if ($errors->has('deadline'))
            <span class="text-danger">{{ $errors->first('deadline') }}</span>
        @endif
    </div>
    <!-- completion_date-->
    <div class="col-md-6"  style="z-index: 1500;">
        <div><label for="completion_date" class="form-label"> completion_date </span></label></div>
        <div class="input-group">
            <input type="" name="completion_date" class="form-control" id="completion_date" autocomplete="off" readonly style="cursor: pointer;" value="{{$data->completion_date}}">
        </div>
        @if ($errors->has('completion_date'))
            <span class="text-danger">{{ $errors->first('completion_date') }}</span>
        @endif
    </div>
    <input type="hidden" name="project_id" id="">
</form>
