<form class="row g-3 auto-width" action="{{ route('tax-calculation.update', $taxCalculation->id)}}" method="post" enctype='multipart/form-data'
    id="source_form">
    @csrf
    @method("PATCH")
    <div class="col-md-6">
        <label for="voucher_master_id" class="form-label">Voucher Master <span class="text-danger"><b>*</b></span></label>
        <select class="form-control" name="voucher_master_id">
            @foreach ($voucher as $list)
                <option value="{{ $list->id }}" {{$list->id == $taxCalculation->voucher_master_id ? 'selected' : '' }}>{{ $list->voucher_name }}</option>
            @endforeach
        </select>
        <span class="text-danger error_voucher_master_id" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="calculation_type" class="form-label">Calculation Type <span class="text-danger"><b>*</b></span></label>
        <select class="form-select" aria-label="calculation_type" name="calculation_type">
            <option value="inclusive" {{ matchSelected($taxCalculation->calculation_type,'inclusive') }}>INCLUSIVE</option>
            <option value="exclusive" {{ matchSelected($taxCalculation->calculation_type,'exclusive') }}>EXCLUSIVE</option>
        </select>
        <span class="text-danger error_calculation_type" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <label for="description" class="form-label">Description</label>
        <textarea class="form-control" max=100 id="description" name="description">{{$taxCalculation->description}}</textarea>
        <span class="text-danger description" style="display:none;">This field is required.</span>
    </div>
</form>
