<form class="row g-3 auto-width" action="{{ route('tax-masters-sub.update', $sub->id) }}" method="POST"
    enctype='multipart/form-data' id="tax_master_sub_form">
    @csrf
    @method('patch')
    <div class="col-md-6">
        <label for="name" class="form-label">Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="name" name="name" aria-describedby="inputGroupPrepend"
            required value="{{ $sub->name }}">
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="tax_master_id" class="form-label">Tax Category <span class="text-danger"><b>*</b></span></label>
        <select class="form-control" name="tax_master_id">
            @foreach ($master as $list)
                <option value="{{ $list->id }}" {{ $list->id == $sub->tax_master_id ? 'selected' : '' }}>
                    {{ $list->name }}
                </option>
            @endforeach
        </select>
        <span class="text-danger error_chart_of_account_type_id" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="percentage" class="form-label">Percentage  <span class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" id="percentage" name="percentage"
            aria-describedby="inputGroupPrepend" required value="{{ $sub->percentage }}">
        <span class="text-danger percentage" style="display:none;">This field is required.</span>
    </div>


    <div class="col-md-6">
        <label for="calculation" class="form-label">Calculation<span class="text-danger"><b>*</b></span></label>
        <select class="form-select" aria-label="calculation" name="calculation">
            <option value="ON-BASIC" {{ old('calculation') == 'ON-BASIC' ? 'selected' : '' }}>ON BASIC</option>
            <option value="ON-TOTAL" {{ old('calculation') == 'ON-TOTAL' ? 'selected' : '' }}>ON TOTAL</option>
        </select>
        <span class="text-danger error_calculation" style="display:none;">This field is required.</span>
    </div>


    <div class="col-md-6">
        <label for="priority" class="form-label">Priority</label>
        <input type="number" class="form-control" id="priority" name="priority" aria-describedby="inputGroupPrepend"
            required value="{{ $sub->priority }}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="description" class="form-label">Description</label>
        <textarea class="form-control" max=100 id="description" name="description">{{ $sub->description }}</textarea>
    </div>
</form>
