<form class="row g-3 auto-width tax_master" action="{{ route('tax-masters.update', $master->id) }}" method="post" enctype='multipart/form-data'
    id="source_form">
    @csrf
    @method("PATCH")
    <div class="col-md-6">
        <label for="name" class="form-label">Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="name" name="name" aria-describedby="inputGroupPrepend"
            required value="{{$master->name}}">
        <span class="text-danger error_name" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="code" class="form-label">Tax Slab code</label>
        <input readonly type="text" class="form-control" id="code" name="code" aria-describedby="inputGroupPrepend" placeholder="18% GST" required  value="{{$master->code}}">
        <span class="text-danger error_code" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="validationCustom01" class="form-label">Tax Category <span class="text-danger"><b>*</b></span></label>
        <select class="form-control" name="tax_category_id">
            @foreach ($category as $list)
                <option value="{{ $list->id }}" {{ $list->id == $master->tax_category_id ? 'selected':'' }}>{{ $list->name }}</option>
            @endforeach
        </select>
        <span class="text-danger error_tax_category_id" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="total_percentage" class="form-label">Total Percentage <span
                class="text-danger"><b>*</b></span></label>
        <input type="number" class="form-control" id="total_percentage" name="total_percentage"
            aria-describedby="inputGroupPrepend" required value="{{$master->total_percentage}}">
        <span class="text-danger error_total_percentage" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="calculation" class="form-label">Calculation<span class="text-danger"><b>*</b></span></label>
        <select class="form-select" aria-label="calculation" name="calculation">
            <option value="ON-BASIC" {{ old('calculation') == 'ON-BASIC' ? 'selected' : '' }}>ON BASIC</option>
            <option value="ON-TOTAL" {{ old('calculation') == 'ON-TOTAL' ? 'selected' : '' }}>ON TOTAL</option>
        </select>
        <span class="text-danger error_calculation" style="display:none;">This field is required.</span>
    </div>


    <div class="col-md-6">
        <label for="priority" class="form-label">Priority </label>
        <input type="number" class="form-control" id="priority" name="priority" aria-describedby="inputGroupPrepend"
            required value="{{$master->priority}}">
        <span class="text-danger error_priority" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="description" class="form-label">Description</label>
        <textarea class="form-control" max=100 id="description" name="description">{{$master->description}}</textarea>
    </div>
</form>
