@extends('layouts.app')
@section('title','Accounts Import')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
    .card {
        margin-bottom: 0rem;
    }
    .form-control {
        height: 33px !important;
    }
</style>

    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
      <div class="breadcrumb-title col-md-6"> Accounts Import </div>
        <div class="col-md-6">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb justify-content-md-end mb-0">
                <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="75" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
                <li class="breadcrumb-item" aria-current="page">Accounts</li>
                <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Accounts</li>
                <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Upload Excel</li>
              </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->

    <!-- main -->
    <div class="card style_table shadow-none radius-5 min-height">

        <div class="card-header py-3">

            @include('layouts.partials.nav-menu')

            <div class="row gx-2">

                <div class="col-lg-4 col-md-4">
                    <h5 class="mb-0">Upload Accounts From Excel</h5>
                </div>
                <div class="col-lg-8 col-md-8">
                    <div class="ms-auto float-md-end">

                        <div class="btn-group">
                            <a href="{{route('accounts-import.index')}}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                        </div>

                        <div class="btn-group">
                            <a href="{!! route('accounts-import.export-sample') !!}" class="btn btn-success" target="_blank">Download Sample</a>
                        </div>
                    </div>
              </div>
            </div>

        </div>

        <input type="hidden" name="hidden_page" id="hidden_page" value="1"/>
        <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name"/>
        <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc"/>
    </div>
    <!-- end main -->

    <div class="row auto">
        <div class="col-xl-12 mx-auto">
            <div class=" shadow-none radius-5 min-height">
                <div class="">
                    <div class="">
                        <form class="row g-3 auto-width form" enctype="multipart/form-data" method="POST">
                            @csrf
                            @method('post')
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-body g-3 row">

                                        <div class="col-md-12" style="text-align: center; display: flex;justify-content: center;">
                                            <div>
                                                <img src="{!! asset('admin/images/upload.png') !!}" width="150" height="150" class="my-3 mt-5">
                                                <br>
    										    <label for="users">Upload Excel File
    										    	<span class="text-danger"><b>*</b></span>
    										    </label>
                                                <br>
    										    <input type="file" class="form-control import_package" name="file" />

    										    <span class="text-danger error_import_package" style="display:none;">This field is required.</span>
                                                <br>
                                                <button class="btn btn-primary import_button w-100">
                                                    <i class="bi bi-upload "></i> Upload Accounts
                                                </button>
                                            </div>
										</div>

                                        <div class="col-4 d-flex justify-content-center mb-3">
                                        </div>

                                        <div class="col-12 justify-content-center mb-3">
                                            <div style="" class="accordion-item">
                                                <h2 class="accordion-header" id="panelsStayOpen-headingTwo">
                                                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false" aria-controls="panelsStayOpen-collapseTwo">
                                                    Guidelines For Account Upload:
                                                  </button>
                                                </h2>
                                                <div style="" id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse" aria-labelledby="panelsStayOpen-headingTwo">
                                                  <div class="accordion-body">
                                                    <strong>Note:</strong><br> <p>Duplicate records will not be saved.<br>If a record already exists, only that record will be skipped.</p>
                                                    <strong>1. Account Name (required):</strong><br> <p>Enter the full Account name (mandatory, unique).</p>
                                                    <strong>2. Department Name (required):</strong><br> <p>Enter the department name (mandatory).</p>
                                                    <strong>3. Short Name (optional):</strong><br> <p>Optionally, include a short name or code for the Account if available.</p>
                                                    <strong>4. Account Code (optional):</strong><br> <p>Optionally, provide a Account code if applicable.</p>
                                                    <strong>5. Priority (optional, integer):</strong><br> <p>If applicable, insert the priority as a whole number.</p>
                                                    <strong>6. Page Break (Yes/No, optional):</strong><br> <p>Indicate "Yes" if a page break is needed, or "No" if not.</p>
                                                    <strong>7. Status (Active/Inactive, optional):</strong><br> <p>Specify the status as "Active" or "Inactive," if applicable.</p>
                                                  </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script>

$(document).on('change', '.import_package', function(e){
    e.preventDefault();

	var ext = this.value.match(/\.(.+)$/)[1];
    var error = 0;

    if(ext != 'xls' && ext != 'xlsx'){
        toastr.error('File must be type of xls & xlsx.');
        this.value = '';
        error = 1;
    }

	const size = (this.files[0]).size;

    if (size > 5e+6) {
        toastr.error('File must be less than 5 MB');
        this.value = '';
        error = 1;
    }

	var formData = new FormData($('.form')[0]);

    $('#commonModalLabel').text('Excel File Preview');
    $('.save_button_span').text('Close');
    $('.bx-save').switchClass('bx bx-save', 'bi bi-x-lg');
    $('.save_button').attr('data-bs-dismiss','modal');
    $('.modal-dialog').css('max-width', '1000px')
});

$(document).on('click', '.import_button', function(event){
    event.preventDefault();
    var file = document.querySelector(".import_package");
    // $('.import_button').attr('disabled', true);

    if(file.value == '' || file.value == null){
        toastr.error('File not selected!');
        error = 1;
        $('.import_button').attr('disabled', false);

    } else {
        var ext   = file.value.match(/\.(.+)$/)[1];
        var error = 0;

        if(ext != 'xls' && ext != 'xlsx'){
            toastr.error('File must be type of xls & xlsx.');
            file.value = '';
            error = 1;
        }

        const size = (file.files[0]).size;

        if (size > 5e+6) {
            toastr.error('File must be less than 5 MB');
            file.value = '';
            error = 1;
        }

        var formData = new FormData($('.form')[0]);

    	if (error == 0) {
            $.ajax({
                url:"{{ route('accounts-import.store')}}",
                type:'POST',
                data: formData,
                contentType: false,
                processData: false,
                success:function(data){
                    if (data.success === true) {
                        $('[name="excel"]').val('');
                        $('.btn-close').click();

                        toastr.success(data.message);
                        setTimeout(function() {
                            window.location.href = "{!! route('accounts-import.index') !!}";
                        }, 3000);
                    } else {
                        $('[name="excel"]').val('');
                        toastr.error(data.message);
                        $('.import_button').attr('disabled', false);
                    }
                }
            });
    	} else {
            $('.import_button').attr('disabled', false);
        }
    }

	error = 1;
});

</script>
@endsection
