@extends('layouts.app')
@section('title', 'Price List')
@section('pages')
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">
    <style type="text/css">
        .breadcrumb-title {
            border-right: none;
        }

        .dataTables_filter {
            display: none;
        }

        div.dt-buttons {
            float: right;
            padding: 8px;
        }
    </style>


    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
        <div class="breadcrumb-title col-md-6"> Price List
        </div>
        <div class="col-md-6">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-md-end mb-0">
                    <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="33"
                            data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
                    <li class="breadcrumb-item" aria-current="page">Price List</li>
                    <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Price List </li>
                </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->

    <div class="card style_table shadow-none radius-5 min-height">
        <div class="card-header py-3">
            @include('layouts.partials.nav-menu')
            <div class="row gx-2">
                <form action="" class="row">

                    <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
                       <!-- Customer-->
                       <div class="input-group">
                        <select class="single-select form-control" name="product_brand">
                            <option selected value="">Select Customer</option>
                            @foreach ($customer as $list)
                                <option value="{{ $list->id }}" {!! $selectedCustomer == $list->id ? 'selected' : '' !!}>{{ $list->type_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    </div>
                    <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
                        <!-- Brand-->
                        <div class="input-group">
                            <select class="single-select form-control" name="product_brand">
                                <option selected value="">All Brand</option>
                                @foreach ($brand as $list)
                                    <option value="{{ $list->id }}" {!! $selectedBrand == $list->id ? 'selected' : '' !!}>{{ $list->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <!-- Product Category-->
                    <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
                        <div class="input-group">
                            <select class="single-select form-control" name="product_category">
                                <option selected value="">All Category</option>
                                @foreach ($product_category as $list)
                                    <option value="{{ $list->id }}" {!! $selectedCategory == $list->id ? 'selected' : '' !!}>{{ $list->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <!-- Product Group-->
                    <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
                        <div class="input-group">
                            <select class="single-select form-control" name="product_group">
                                <option selected value="">All Group</option>
                                @foreach ($product_group as $list)
                                    <option value="{{ $list->id }}" {!! $selectedGroup == $list->id ? 'selected' : '' !!}>{{ $list->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                   <!-- Submit Button -->
                    <div class="col-lg-1 col-md-1">
                        <div class="btn-group">
                            <button type="submit" class="btn btn-success">Submit</button>
                        </div>
                    </div>
                    
                    <!-- Back Button on the Right -->
                    <div class="col-lg-1 col-md-1" style="margin-left: 156px; width:100px">
                        <div class="ms-auto float-md-end">
                            <a href="{{route('products.index')}}" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                        </div>
                    </div>
                </div>
            </div>
        <div class="card-body" id="tables">

            @include('products.price-table')

            <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
            <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
            <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
        </div>

    @endsection
    @section('js')
    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#myTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                    extend: 'collection',
                    text: 'Export',
                    className: 'blue-button',
                    buttons: [{
                            extend: 'excel',
                            title: 'PriceList  '  + new Date().toLocaleDateString(),
                            filename: 'PriceList'
                        },
                        {
                            extend: 'csv',
                            title: 'PriceList ' + new Date().toLocaleDateString(),
                            filename: 'PriceList'
                        },
                        {
                            extend: 'print'
                        }
                    ]
                }],
                paging: false,
                ordering: false,
                info: false
            });
        });
    </script>
    @endsection
